/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.tsp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERBitString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cmp.PKIFreeText;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampResp;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TSPException;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TSPValidationException;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TimeStampTokenGenerator;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms) {
        this(tokenGenerator, acceptedAlgorithms, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies) {
        this(tokenGenerator, acceptedAlgorithms, acceptedPolicies, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies, Set acceptedExtensions) {
        this.tokenGenerator = tokenGenerator;
        this.acceptedAlgorithms = this.convert(acceptedAlgorithms);
        this.acceptedPolicies = this.convert(acceptedPolicies);
        this.acceptedExtensions = this.convert(acceptedExtensions);
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String statusString) {
        this.statusStrings.add(new DERUTF8String(statusString));
    }

    private void setFailInfoField(int field) {
        this.failInfo |= field;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.status));
        if (this.statusStrings.size() > 0) {
            v.add(PKIFreeText.getInstance(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            FailInfo failInfoBitString = new FailInfo(this.failInfo);
            v.add(failInfoBitString);
        }
        return PKIStatusInfo.getInstance(new DERSequence(v));
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        try {
            return this.generateGrantedResponse(request, serialNumber, genTime, null);
        }
        catch (Exception e) {
            return this.generateRejectedResponse(e);
        }
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        return this.generateGrantedResponse(request, serialNumber, genTime, null);
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest request, BigInteger serialNumber, Date genTime, String statusString) throws TSPException {
        ContentInfo tstTokenContentInfo;
        if (genTime == null) {
            throw new TSPValidationException("The time source is not available.", 512);
        }
        request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
        this.status = 0;
        this.statusStrings = new ASN1EncodableVector();
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
        try {
            tstTokenContentInfo = this.tokenGenerator.generate(request, serialNumber, genTime).toCMSSignedData().toASN1Structure();
        }
        catch (TSPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TSPException("Timestamp token received cannot be converted to ContentInfo", e);
        }
        TimeStampResp resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateRejectedResponse(Exception exception) throws TSPException {
        if (exception instanceof TSPValidationException) {
            return this.generateFailResponse(2, ((TSPValidationException)exception).getFailureCode(), exception.getMessage());
        }
        if (exception instanceof TSPException) {
            return this.generateFailResponse(2, 32, exception.getMessage());
        }
        return this.generateFailResponse(2, 0x40000000, exception.getMessage());
    }

    public TimeStampResponse generateFailResponse(int status, int failInfoField, String statusString) throws TSPException {
        this.status = status;
        this.statusStrings = new ASN1EncodableVector();
        this.setFailInfoField(failInfoField);
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
        TimeStampResp resp = new TimeStampResp(pkiStatusInfo, null);
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException e) {
            throw new TSPException("created badly formatted response!");
        }
    }

    private Set convert(Set orig) {
        if (orig == null) {
            return orig;
        }
        HashSet<ASN1ObjectIdentifier> con = new HashSet<ASN1ObjectIdentifier>(orig.size());
        Iterator it = orig.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                con.add(new ASN1ObjectIdentifier((String)o));
                continue;
            }
            con.add((ASN1ObjectIdentifier)o);
        }
        return con;
    }

    class FailInfo
    extends DERBitString {
        FailInfo(int failInfoValue) {
            super(FailInfo.getBytes(failInfoValue), FailInfo.getPadBits(failInfoValue));
        }
    }
}

