/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.pkcs.jcajce;

import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.JcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptor;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptorProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import msfpay.cfca.sadk.org.bouncycastle.operator.SecretKeySizeProvider;

public class JcePKCSPBEInputDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private boolean wrongPKCS12Zero = false;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setTryWrongPKCS12Zero(boolean tryWrong) {
        this.wrongPKCS12Zero = tryWrong;
        return this;
    }

    public JcePKCSPBEInputDecryptorProviderBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){
            private Cipher cipher;
            private SecretKey key;
            private AlgorithmIdentifier encryptionAlg;

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                try {
                    if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                        this.key = keyFact.generateSecret(pbeSpec);
                        if (this.key instanceof BCPBEKey) {
                            ((BCPBEKey)this.key).setTryWrongPKCS12Zero(JcePKCSPBEInputDecryptorProviderBuilder.this.wrongPKCS12Zero);
                        }
                        this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(algorithm.getId());
                        this.cipher.init(2, (Key)this.key, defParams);
                        this.encryptionAlg = algorithmIdentifier;
                    } else if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                        PBES2Parameters alg = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                        PBKDF2Params func = PBKDF2Params.getInstance(alg.getKeyDerivationFunc().getParameters());
                        AlgorithmIdentifier encScheme = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                        SecretKeyFactory keyFact = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createSecretKeyFactory(alg.getKeyDerivationFunc().getAlgorithm().getId());
                        this.key = func.isDefaultPrf() ? keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme))) : keyFact.generateSecret(new PBKDF2KeySpec(password, func.getSalt(), func.getIterationCount().intValue(), JcePKCSPBEInputDecryptorProviderBuilder.this.keySizeProvider.getKeySize(encScheme), func.getPrf()));
                        this.cipher = JcePKCSPBEInputDecryptorProviderBuilder.this.helper.createCipher(alg.getEncryptionScheme().getAlgorithm().getId());
                        this.encryptionAlg = AlgorithmIdentifier.getInstance(alg.getEncryptionScheme());
                        ASN1Encodable encParams = alg.getEncryptionScheme().getParameters();
                        if (encParams instanceof ASN1OctetString) {
                            this.cipher.init(2, (Key)this.key, new IvParameterSpec(ASN1OctetString.getInstance(encParams).getOctets()));
                        } else {
                            GOST28147Parameters gParams = GOST28147Parameters.getInstance(encParams);
                            this.cipher.init(2, (Key)this.key, new GOST28147ParameterSpec(gParams.getEncryptionParamSet(), gParams.getIV()));
                        }
                    }
                }
                catch (Exception e) {
                    throw new OperatorCreationException("unable to create InputDecryptor: " + e.getMessage(), e);
                }
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return encryptionAlg;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, cipher);
                    }
                };
            }
        };
    }
}

