/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.pkcs.bc;

import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.operator.MacCalculator;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcDigestProvider;
import msfpay.cfca.sadk.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import msfpay.cfca.sadk.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import msfpay.cfca.sadk.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

