/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.pkcs;

import java.io.OutputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.MacData;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import msfpay.cfca.sadk.org.bouncycastle.operator.MacCalculator;
import msfpay.cfca.sadk.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import msfpay.cfca.sadk.org.bouncycastle.pkcs.PKCSException;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder builder) {
        this.builder = builder;
    }

    public MacData build(char[] password, byte[] data) throws PKCSException {
        MacCalculator macCalculator;
        try {
            macCalculator = this.builder.build(password);
            OutputStream out = macCalculator.getOutputStream();
            out.write(data);
            out.close();
        }
        catch (Exception e) {
            throw new PKCSException("unable to process data: " + e.getMessage(), e);
        }
        AlgorithmIdentifier algId = macCalculator.getAlgorithmIdentifier();
        DigestInfo dInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algId.getParameters());
        return new MacData(dInfo, params.getIV(), params.getIterations().intValue());
    }
}

