/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.operator.bc;

import java.security.SecureRandom;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.crypto.Wrapper;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import msfpay.cfca.sadk.org.bouncycastle.operator.GenericKey;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorException;
import msfpay.cfca.sadk.org.bouncycastle.operator.SymmetricKeyWrapper;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        byte[] contentEncryptionKeySpec = OperatorUtils.getKeyBytes(encryptionKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(contentEncryptionKeySpec, 0, contentEncryptionKeySpec.length);
    }
}

