/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.operator.bc;

import java.io.IOException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import msfpay.cfca.sadk.org.bouncycastle.crypto.Signer;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.signers.DSADigestSigner;
import msfpay.cfca.sadk.org.bouncycastle.crypto.signers.DSASigner;
import msfpay.cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import msfpay.cfca.sadk.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSADigestSigner(new DSASigner(), dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

