/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import msfpay.cfca.sadk.org.bouncycastle.crypto.Signer;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import msfpay.cfca.sadk.org.bouncycastle.operator.ContentSigner;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import msfpay.cfca.sadk.org.bouncycastle.operator.RuntimeOperatorException;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcDigestProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcSignerOutputStream;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter privateKey) throws OperatorCreationException {
        final Signer sig = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            sig.init(true, new ParametersWithRandom(privateKey, this.random));
        } else {
            sig.init(true, privateKey);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(sig);
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

