/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.EncryptionScheme;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBEParameter;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.JcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import msfpay.cfca.sadk.org.bouncycastle.openssl.PEMException;
import msfpay.cfca.sadk.org.bouncycastle.openssl.jcajce.PEMUtilities;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptor;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptorProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            public InputDecryptor get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = PEMUtilities.generateSecretKeyForPKCS5Scheme2(oid, password, salt, iterationCount);
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(oid);
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (PEMUtilities.isPKCS12(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getIV(), params.getIterations().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        PBEKeySpec pbeSpec = new PBEKeySpec(password);
                        SecretKeyFactory secKeyFact = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithm.getAlgorithm().getId());
                        PBEParameterSpec defParams = new PBEParameterSpec(params.getSalt(), params.getIterationCount().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, (Key)secKeyFact.generateSecret(pbeSpec), defParams);
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithm;
                        }

                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, cipher);
                        }
                    };
                }
                catch (IOException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
            }
        };
    }
}

