/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509AttributeCertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import msfpay.cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.jce.PKCS10CertificationRequest;
import msfpay.cfca.sadk.org.bouncycastle.openssl.MiscPEMGenerator;
import msfpay.cfca.sadk.org.bouncycastle.openssl.PEMEncryptor;
import msfpay.cfca.sadk.org.bouncycastle.x509.X509AttributeCertificate;
import msfpay.cfca.sadk.org.bouncycastle.x509.X509V2AttributeCertificate;

public class JcaMiscPEMGenerator
extends MiscPEMGenerator {
    public JcaMiscPEMGenerator(Object o) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o));
    }

    public JcaMiscPEMGenerator(Object o, PEMEncryptor encryptor) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o), encryptor);
    }

    private static Object convertObject(Object o) throws IOException {
        if (o instanceof X509Certificate) {
            try {
                return new JcaX509CertificateHolder((X509Certificate)o);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Cannot encode object: " + e.toString());
            }
        }
        if (o instanceof X509CRL) {
            try {
                return new JcaX509CRLHolder((X509CRL)o);
            }
            catch (CRLException e) {
                throw new IllegalArgumentException("Cannot encode object: " + e.toString());
            }
        }
        if (o instanceof KeyPair) {
            return JcaMiscPEMGenerator.convertObject(((KeyPair)o).getPrivate());
        }
        if (o instanceof PrivateKey) {
            return PrivateKeyInfo.getInstance(((Key)o).getEncoded());
        }
        if (o instanceof PublicKey) {
            return SubjectPublicKeyInfo.getInstance(((PublicKey)o).getEncoded());
        }
        if (o instanceof X509AttributeCertificate) {
            return new JcaX509AttributeCertificateHolder((X509V2AttributeCertificate)o);
        }
        if (o instanceof PKCS10CertificationRequest) {
            return new msfpay.cfca.sadk.org.bouncycastle.pkcs.PKCS10CertificationRequest(((PKCS10CertificationRequest)o).getEncoded());
        }
        return o;
    }
}

