/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.jce.spec;

import java.security.spec.AlgorithmParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.GOST3410NamedParameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.GOST3410ParamSetParameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import msfpay.cfca.sadk.org.bouncycastle.jce.interfaces.GOST3410Params;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public class GOST3410ParameterSpec
implements AlgorithmParameterSpec,
GOST3410Params {
    private GOST3410PublicKeyParameterSetSpec keyParameters;
    private String keyParamSetOID;
    private String digestParamSetOID;
    private String encryptionParamSetOID;

    public GOST3410ParameterSpec(String keyParamSetID, String digestParamSetOID, String encryptionParamSetOID) {
        GOST3410ParamSetParameters ecP;
        block3: {
            ecP = null;
            try {
                ecP = GOST3410NamedParameters.getByOID(new ASN1ObjectIdentifier(keyParamSetID));
            }
            catch (IllegalArgumentException e) {
                ASN1ObjectIdentifier oid = GOST3410NamedParameters.getOID(keyParamSetID);
                if (oid == null) break block3;
                keyParamSetID = oid.getId();
                ecP = GOST3410NamedParameters.getByOID(oid);
            }
        }
        if (ecP == null) {
            throw new IllegalArgumentException("no key parameter set for passed in name/OID.");
        }
        this.keyParameters = new GOST3410PublicKeyParameterSetSpec(ecP.getP(), ecP.getQ(), ecP.getA());
        this.keyParamSetOID = keyParamSetID;
        this.digestParamSetOID = digestParamSetOID;
        this.encryptionParamSetOID = encryptionParamSetOID;
    }

    public GOST3410ParameterSpec(String keyParamSetID, String digestParamSetOID) {
        this(keyParamSetID, digestParamSetOID, null);
    }

    public GOST3410ParameterSpec(String keyParamSetID) {
        this(keyParamSetID, CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet.getId(), null);
    }

    public GOST3410ParameterSpec(GOST3410PublicKeyParameterSetSpec spec) {
        this.keyParameters = spec;
        this.digestParamSetOID = CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet.getId();
        this.encryptionParamSetOID = null;
    }

    public String getPublicKeyParamSetOID() {
        return this.keyParamSetOID;
    }

    public GOST3410PublicKeyParameterSetSpec getPublicKeyParameters() {
        return this.keyParameters;
    }

    public String getDigestParamSetOID() {
        return this.digestParamSetOID;
    }

    public String getEncryptionParamSetOID() {
        return this.encryptionParamSetOID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digestParamSetOID == null ? 0 : this.digestParamSetOID.hashCode());
        result = 31 * result + (this.encryptionParamSetOID == null ? 0 : this.encryptionParamSetOID.hashCode());
        result = 31 * result + (this.keyParamSetOID == null ? 0 : this.keyParamSetOID.hashCode());
        result = 31 * result + (this.keyParameters == null ? 0 : this.keyParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GOST3410ParameterSpec other = (GOST3410ParameterSpec)obj;
        if (this.digestParamSetOID == null ? other.digestParamSetOID != null : !this.digestParamSetOID.equals(other.digestParamSetOID)) {
            return false;
        }
        if (this.encryptionParamSetOID == null ? other.encryptionParamSetOID != null : !this.encryptionParamSetOID.equals(other.encryptionParamSetOID)) {
            return false;
        }
        if (this.keyParamSetOID == null ? other.keyParamSetOID != null : !this.keyParamSetOID.equals(other.keyParamSetOID)) {
            return false;
        }
        return !(this.keyParameters == null ? other.keyParameters != null : !this.keyParameters.equals(other.keyParameters));
    }

    public static GOST3410ParameterSpec fromPublicKeyAlg(GOST3410PublicKeyAlgParameters params) {
        if (params.getEncryptionParamSet() != null) {
            return new GOST3410ParameterSpec(params.getPublicKeyParamSet().getId(), params.getDigestParamSet().getId(), params.getEncryptionParamSet().getId());
        }
        return new GOST3410ParameterSpec(params.getPublicKeyParamSet().getId(), params.getDigestParamSet().getId());
    }
}

