/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.jce;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import msfpay.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECKeyUtil {
    public static PublicKey publicToExplicitParameters(PublicKey key, String providerName) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider: " + providerName);
        }
        return ECKeyUtil.publicToExplicitParameters(key, provider);
    }

    public static PublicKey publicToExplicitParameters(PublicKey key, Provider provider) throws IllegalArgumentException, NoSuchAlgorithmException {
        try {
            X9ECParameters curveParams;
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(key.getEncoded()));
            AlgorithmIdentifier algorithmIdentifier = info.getAlgorithm();
            if (algorithmIdentifier == null) {
                throw new IllegalArgumentException("cannot parse algorithmIdentifier from PublicKeyInfo");
            }
            if (CryptoProObjectIdentifiers.gostR3410_2001.equals(algorithmIdentifier.getAlgorithm())) {
                throw new IllegalArgumentException("cannot convert GOST key to explicit parameters.");
            }
            X962Parameters params = X962Parameters.getInstance(algorithmIdentifier.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
                curveParams = ECUtil.getNamedCurveByOid(oid);
                curveParams = new X9ECParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH());
            } else if (params.isImplicitlyCA()) {
                curveParams = new X9ECParameters(BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getG(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getN(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getH());
            } else {
                return key;
            }
            params = new X962Parameters(curveParams);
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), info.getPublicKeyData().getBytes());
            KeyFactory keyFact = KeyFactory.getInstance(key.getAlgorithm(), provider);
            return keyFact.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    public static PrivateKey privateToExplicitParameters(PrivateKey key, String providerName) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider: " + providerName);
        }
        return ECKeyUtil.privateToExplicitParameters(key, provider);
    }

    public static PrivateKey privateToExplicitParameters(PrivateKey key, Provider provider) throws IllegalArgumentException, NoSuchAlgorithmException {
        try {
            X9ECParameters curveParams;
            PrivateKeyInfo info = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(key.getEncoded()));
            AlgorithmIdentifier algorithmIdentifier = info.getPrivateKeyAlgorithm();
            if (algorithmIdentifier == null) {
                throw new IllegalArgumentException("cannot parse algorithmIdentifier from PrivateKeyInfo");
            }
            if (CryptoProObjectIdentifiers.gostR3410_2001.equals(algorithmIdentifier.getAlgorithm())) {
                throw new UnsupportedEncodingException("cannot convert GOST key to explicit parameters.");
            }
            X962Parameters params = X962Parameters.getInstance(algorithmIdentifier.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
                curveParams = ECUtil.getNamedCurveByOid(oid);
                curveParams = new X9ECParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH());
            } else if (params.isImplicitlyCA()) {
                curveParams = new X9ECParameters(BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getG(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getN(), BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getH());
            } else {
                return key;
            }
            params = new X962Parameters(curveParams);
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), info.parsePrivateKey());
            KeyFactory keyFact = KeyFactory.getInstance(key.getAlgorithm(), provider);
            return keyFact.generatePrivate(new PKCS8EncodedKeySpec(info.getEncoded()));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    private static class UnexpectedException
    extends RuntimeException {
        private static final long serialVersionUID = 2627865891642235697L;
        private Throwable cause;

        UnexpectedException(Throwable cause) {
            super(cause.toString());
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

