/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import msfpay.cfca.sadk.org.bouncycastle.crypto.generators.SM2KeyPairGenerator;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import msfpay.cfca.sadk.org.bouncycastle.jce.ECNamedCurveTable;
import msfpay.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.util.Integers;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class SM2ECDH
    extends SM2 {
        public SM2ECDH() {
            super("SM2ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class SM2ECDSA
    extends SM2 {
        public SM2ECDSA() {
            super("SM2ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class SM2
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        SM2KeyPairGenerator engine = new SM2KeyPairGenerator();
        ECParameterSpec ecParams = null;
        final int strength = 256;
        int certainty = 50;
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Map ecParameters = new HashMap();

        public SM2() {
            super("SM2");
            this.algorithm = "SM2";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public SM2(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        public void initialize(int strength, SecureRandom random) {
            this.ecParams = (ECParameterSpec)ecParameters.get(Integers.valueOf(strength));
            if (this.ecParams == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
            this.engine.init(this.param);
            this.initialised = true;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECNamedCurveGenParameterSpec) {
                String curveName = ((ECNamedCurveGenParameterSpec)params).getName();
                X9ECParameters ecP = SECNamedCurves.getByName(curveName);
                if (ecP == null) {
                    try {
                        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveName);
                        ecP = SECNamedCurves.getByOID(oid);
                        if (ecP == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                    }
                }
                this.ecParams = new ECNamedCurveParameterSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), null);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && this.configuration.getEcImplicitlyCa() != null) {
                ECParameterSpec p = this.configuration.getEcImplicitlyCa();
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && this.configuration.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("SM2 Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, pub, this.configuration), new BCECPrivateKey(this.algorithm, priv, this.configuration));
            }
            ECParameterSpec p = this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }

        static {
            ecParameters.put(Integers.valueOf(256), ECNamedCurveTable.getParameterSpec("sm2"));
        }
    }
}

