/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ecgost;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PrivateKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import msfpay.cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import msfpay.cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import msfpay.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            if (k.getParameters() != null) {
                return new ECPublicKeySpec(k.getQ(), k.getParameters());
            }
            ECParameterSpec implicitSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPublicKeySpec(k.getQ(), implicitSpec);
        }
        if (spec.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            if (k.getParameters() != null) {
                return new ECPrivateKeySpec(k.getD(), k.getParameters());
            }
            ECParameterSpec implicitSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            return new ECPrivateKeySpec(k.getD(), implicitSpec);
        }
        return super.engineGetKeySpec(key, spec);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("key type unknown");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            return new BCECGOST3410PrivateKey((ECPrivateKeySpec)keySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPublicKeySpec) {
            return new BCECGOST3410PublicKey((ECPublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            return new BCECGOST3410PrivateKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            return new BCECGOST3410PublicKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }
}

