/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.DSAParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.DSAPublicKeyParameters;

public class DSAUtil {
    public static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};

    public static boolean isDsaOid(ASN1ObjectIdentifier algOid) {
        for (int i = 0; i != dsaOids.length; ++i) {
            if (!algOid.equals(dsaOids[i])) continue;
            return true;
        }
        return false;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof DSAPublicKey) {
            DSAPublicKey k = (DSAPublicKey)key;
            return new DSAPublicKeyParameters(k.getY(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey k = (DSAPrivateKey)key;
            return new DSAPrivateKeyParameters(k.getX(), new DSAParameters(k.getParams().getP(), k.getParams().getQ(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA private key.");
    }
}

