/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.util;

import java.io.IOException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ECPoint;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;

public class SubjectPublicKeyInfoFactory {
    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters pub = (RSAKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(pub.getModulus(), pub.getExponent()));
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new ASN1Integer(pub.getY()));
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            X962Parameters params;
            ECPublicKeyParameters pub = (ECPublicKeyParameters)publicKey;
            ECDomainParameters domainParams = pub.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else if (domainParams instanceof ECNamedDomainParameters) {
                params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
            }
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(pub.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        }
        throw new IOException("key parameters not recognised.");
    }
}

