/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.tls;

import java.io.IOException;
import msfpay.cfca.sadk.org.bouncycastle.crypto.Digest;
import msfpay.cfca.sadk.org.bouncycastle.crypto.tls.TlsCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import msfpay.cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import msfpay.cfca.sadk.org.bouncycastle.crypto.tls.TlsMac;
import msfpay.cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import msfpay.cfca.sadk.org.bouncycastle.util.Arrays;

public class TlsNullCipher
implements TlsCipher {
    protected TlsContext context;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsNullCipher(TlsContext context) {
        this.context = context;
        this.writeMac = null;
        this.readMac = null;
    }

    public TlsNullCipher(TlsContext context, Digest clientWriteDigest, Digest serverWriteDigest) throws IOException {
        if (clientWriteDigest == null != (serverWriteDigest == null)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        TlsMac clientWriteMac = null;
        TlsMac serverWriteMac = null;
        if (clientWriteDigest != null) {
            int key_block_size = clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
            byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
            int offset = 0;
            clientWriteMac = new TlsMac(context, clientWriteDigest, key_block, offset, clientWriteDigest.getDigestSize());
            serverWriteMac = new TlsMac(context, serverWriteDigest, key_block, offset += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
            if ((offset += serverWriteDigest.getDigestSize()) != key_block_size) {
                throw new TlsFatalAlert(80);
            }
        }
        if (context.isServer()) {
            this.writeMac = serverWriteMac;
            this.readMac = clientWriteMac;
        } else {
            this.writeMac = clientWriteMac;
            this.readMac = serverWriteMac;
        }
    }

    public int getPlaintextLimit(int ciphertextLimit) {
        int result = ciphertextLimit;
        if (this.writeMac != null) {
            result -= this.writeMac.getSize();
        }
        return result;
    }

    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        if (this.writeMac == null) {
            return Arrays.copyOfRange(plaintext, offset, offset + len);
        }
        byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        byte[] ciphertext = new byte[len + mac.length];
        System.arraycopy(plaintext, offset, ciphertext, 0, len);
        System.arraycopy(mac, 0, ciphertext, len, mac.length);
        return ciphertext;
    }

    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] computedMac;
        if (this.readMac == null) {
            return Arrays.copyOfRange(ciphertext, offset, offset + len);
        }
        int macSize = this.readMac.getSize();
        if (len < macSize) {
            throw new TlsFatalAlert(50);
        }
        int macInputLen = len - macSize;
        byte[] receivedMac = Arrays.copyOfRange(ciphertext, offset + macInputLen, offset + len);
        if (!Arrays.constantTimeAreEqual(receivedMac, computedMac = this.readMac.calculateMac(seqNo, type, ciphertext, offset, macInputLen))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + macInputLen);
    }
}

