/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.tls;

import msfpay.cfca.sadk.org.bouncycastle.util.Arrays;

public class SecurityParameters {
    int entity = -1;
    int cipherSuite = -1;
    short compressionAlgorithm = (short)-1;
    int prfAlgorithm = -1;
    int verifyDataLength = -1;
    byte[] masterSecret = null;
    byte[] clientRandom = null;
    byte[] serverRandom = null;
    short maxFragmentLength = (short)-1;
    boolean truncatedHMac = false;
    boolean encryptThenMAC = false;

    void copySessionParametersFrom(SecurityParameters other) {
        this.entity = other.entity;
        this.cipherSuite = other.cipherSuite;
        this.compressionAlgorithm = other.compressionAlgorithm;
        this.prfAlgorithm = other.prfAlgorithm;
        this.verifyDataLength = other.verifyDataLength;
        this.masterSecret = Arrays.clone(other.masterSecret);
    }

    void clear() {
        if (this.masterSecret != null) {
            Arrays.fill(this.masterSecret, (byte)0);
            this.masterSecret = null;
        }
    }

    public int getEntity() {
        return this.entity;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public short getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getPrfAlgorithm() {
        return this.prfAlgorithm;
    }

    public int getVerifyDataLength() {
        return this.verifyDataLength;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }
}

