/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import msfpay.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import msfpay.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import msfpay.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.WNafUtil;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger phi;
        BigInteger n;
        BigInteger q;
        int strength = this.param.getStrength();
        int qBitlength = strength >>> 1;
        int pBitlength = strength - qBitlength;
        int mindiffbits = strength / 3;
        int minWeight = strength >>> 2;
        BigInteger e = this.param.getPublicExponent();
        BigInteger p = this.chooseRandomPrime(pBitlength, e);
        while (true) {
            BigInteger diff;
            if ((diff = (q = this.chooseRandomPrime(qBitlength, e)).subtract(p).abs()).bitLength() < mindiffbits) {
                continue;
            }
            n = p.multiply(q);
            if (n.bitLength() != strength) {
                p = p.max(q);
                continue;
            }
            if (WNafUtil.getNafWeight(n) >= minWeight) break;
            p = this.chooseRandomPrime(pBitlength, e);
        }
        if (p.compareTo(q) < 0) {
            phi = p;
            p = q;
            q = phi;
        }
        BigInteger pSub1 = p.subtract(ONE);
        BigInteger qSub1 = q.subtract(ONE);
        phi = pSub1.multiply(qSub1);
        BigInteger d = e.modInverse(phi);
        BigInteger dP = d.remainder(pSub1);
        BigInteger dQ = d.remainder(qSub1);
        BigInteger qInv = q.modInverse(p);
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, n, e), new RSAPrivateCrtKeyParameters(n, e, d, p, q, dP, dQ, qInv));
    }

    protected BigInteger chooseRandomPrime(int bitlength, BigInteger e) {
        BigInteger p;
        while ((p = new BigInteger(bitlength, 1, this.param.getRandom())).mod(e).equals(ONE) || !p.isProbablePrime(this.param.getCertainty()) || !e.gcd(p.subtract(ONE)).equals(ONE)) {
        }
        return p;
    }
}

