/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.generators;

import msfpay.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.Digest;
import msfpay.cfca.sadk.org.bouncycastle.crypto.PBEParametersGenerator;
import msfpay.cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;

public class OpenSSLPBEParametersGenerator
extends PBEParametersGenerator {
    private Digest digest = new MD5Digest();

    public void init(byte[] password, byte[] salt) {
        super.init(password, salt, 1);
    }

    private byte[] generateDerivedKey(int bytesNeeded) {
        byte[] buf = new byte[this.digest.getDigestSize()];
        byte[] key = new byte[bytesNeeded];
        int offset = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(buf, 0);
            int len = bytesNeeded > buf.length ? buf.length : bytesNeeded;
            System.arraycopy(buf, 0, key, offset, len);
            offset += len;
            if ((bytesNeeded -= len) == 0) break;
            this.digest.reset();
            this.digest.update(buf, 0, buf.length);
        }
        return key;
    }

    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }

    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), dKey, keySize, ivSize);
    }

    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }
}

