/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.engines;

import java.math.BigInteger;

public class CramerShoupCiphertext {
    BigInteger u1;
    BigInteger u2;
    BigInteger e;
    BigInteger v;

    public CramerShoupCiphertext() {
    }

    public CramerShoupCiphertext(BigInteger u1, BigInteger u2, BigInteger e, BigInteger v) {
        this.u1 = u1;
        this.u2 = u2;
        this.e = e;
        this.v = v;
    }

    public CramerShoupCiphertext(byte[] c) {
        int off = 0;
        byte[] size = new byte[4];
        System.arraycopy(c, off, size, 0, 4);
        int s = this.byteArrayToInt(size);
        byte[] tmp = new byte[s];
        System.arraycopy(c, off += 4, tmp, 0, s);
        this.u1 = new BigInteger(tmp);
        System.arraycopy(c, off += s, size, 0, 4);
        s = this.byteArrayToInt(size);
        tmp = new byte[s];
        System.arraycopy(c, off += 4, tmp, 0, s);
        this.u2 = new BigInteger(tmp);
        System.arraycopy(c, off += s, size, 0, 4);
        s = this.byteArrayToInt(size);
        tmp = new byte[s];
        System.arraycopy(c, off += 4, tmp, 0, s);
        this.e = new BigInteger(tmp);
        System.arraycopy(c, off += s, size, 0, 4);
        s = this.byteArrayToInt(size);
        tmp = new byte[s];
        System.arraycopy(c, off += 4, tmp, 0, s);
        off += s;
        this.v = new BigInteger(tmp);
    }

    public BigInteger getU1() {
        return this.u1;
    }

    public void setU1(BigInteger u1) {
        this.u1 = u1;
    }

    public BigInteger getU2() {
        return this.u2;
    }

    public void setU2(BigInteger u2) {
        this.u2 = u2;
    }

    public BigInteger getE() {
        return this.e;
    }

    public void setE(BigInteger e) {
        this.e = e;
    }

    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger v) {
        this.v = v;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("u1: " + this.u1.toString());
        result.append("\nu2: " + this.u2.toString());
        result.append("\ne: " + this.e.toString());
        result.append("\nv: " + this.v.toString());
        return result.toString();
    }

    public byte[] toByteArray() {
        byte[] u1Bytes = this.u1.toByteArray();
        int u1Length = u1Bytes.length;
        byte[] u2Bytes = this.u2.toByteArray();
        int u2Length = u2Bytes.length;
        byte[] eBytes = this.e.toByteArray();
        int eLength = eBytes.length;
        byte[] vBytes = this.v.toByteArray();
        int vLength = vBytes.length;
        int off = 0;
        byte[] result = new byte[u1Length + u2Length + eLength + vLength + 16];
        System.arraycopy(this.intToByteArray(u1Length), 0, result, 0, 4);
        System.arraycopy(u1Bytes, 0, result, off += 4, u1Length);
        System.arraycopy(this.intToByteArray(u2Length), 0, result, off += u1Length, 4);
        System.arraycopy(u2Bytes, 0, result, off += 4, u2Length);
        System.arraycopy(this.intToByteArray(eLength), 0, result, off += u2Length, 4);
        System.arraycopy(eBytes, 0, result, off += 4, eLength);
        System.arraycopy(this.intToByteArray(vLength), 0, result, off += eLength, 4);
        System.arraycopy(vBytes, 0, result, off += 4, vLength);
        return result;
    }

    private byte[] intToByteArray(int in) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)(in >>> i * 8);
        }
        return bytes;
    }

    private int byteArrayToInt(byte[] in) {
        if (in.length != 4) {
            return -1;
        }
        int r = 0;
        for (int i = 3; i >= 0; --i) {
            r += in[i] << (3 - i) * 8;
        }
        return r;
    }
}

