/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import msfpay.cfca.sadk.org.bouncycastle.crypto.BasicAgreement;
import msfpay.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.MQVPrivateParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.MQVPublicParameters;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import msfpay.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.MQVPublicKeySpec;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.ECAlgorithms;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.ECConstants;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;

public final class SM2MQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (MQVPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        int count;
        int start;
        int length = this.getFieldSize();
        ECPoint agreement = this.calculateMqvAgreement(pubKey);
        byte[] value = new byte[length * 2];
        byte[] bytes = agreement.getXCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, 0, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, length - count, count);
        }
        bytes = agreement.getYCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, length, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, 2 * length - count, count);
        }
        return new BigInteger(1, value);
    }

    public final byte[] getAgreementBytes(ECPoint agreement) {
        int count;
        int start;
        int length = this.getFieldSize();
        byte[] value = new byte[length * 2];
        byte[] bytes = agreement.getXCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, 0, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, length - count, count);
        }
        bytes = agreement.getYCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, length, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, 2 * length - count, count);
        }
        return value;
    }

    public ECPoint calculateMqvAgreement(CipherParameters pubKey) {
        MQVPublicParameters pubParams = (MQVPublicParameters)pubKey;
        ECPrivateKeyParameters staticPrivateKey = this.privParams.getStaticPrivateKey();
        ECPoint agreement = this.calculateMqvAgreement(staticPrivateKey.getParameters(), staticPrivateKey, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), pubParams.getStaticPublicKey(), pubParams.getEphemeralPublicKey()).normalize();
        if (agreement.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return agreement;
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters parameters, ECPrivateKeyParameters d1U, ECPrivateKeyParameters d2U, ECPublicKeyParameters Q2U, ECPublicKeyParameters Q1V, ECPublicKeyParameters Q2V) {
        BigInteger n = parameters.getN();
        BigInteger h = parameters.getH();
        int e = (n.bitLength() + 1) / 2 - 1;
        BigInteger powE = ECConstants.ONE.shiftLeft(e);
        ECCurve curve = parameters.getCurve();
        ECPoint[] points = new ECPoint[]{ECAlgorithms.importPoint(curve, Q2U == null ? parameters.getG().multiply(d2U.getD()) : Q2U.getQ()), ECAlgorithms.importPoint(curve, Q1V.getQ()), ECAlgorithms.importPoint(curve, Q2V.getQ())};
        curve.normalizeAll(points);
        ECPoint q2U = points[0];
        ECPoint q1V = points[1];
        ECPoint q2V = points[2];
        BigInteger xU = q2U.getXCoord().toBigInteger();
        BigInteger XU = powE.add(xU.and(powE.subtract(SM2Params.ONE)));
        BigInteger tU = d1U.getD().add(XU.multiply(d2U.getD())).mod(n);
        BigInteger xV = q2V.getXCoord().toBigInteger();
        BigInteger XV = powE.add(xV.and(powE.subtract(SM2Params.ONE)));
        FixedPointCombMultiplier m = new FixedPointCombMultiplier();
        return m.multiply(q1V.add(q2V.multiply(XV)), h.multiply(tU));
    }

    public static void testParams() throws Exception {
        ECParameterSpec spec = SM2Params.sm2dhtest;
        ECDomainParameters params = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH());
        BigInteger dA = SM2Params.fromHex("6FCBA2EF 9AE0AB90 2BC3BDE3 FF915D44 BA4CC78F 88E2F8E7 F8996D3B 8CCEEDEE");
        BigInteger xPA = SM2Params.fromHex("3099093B F3C137D8 FCBBCDF4 A2AE50F3 B0F216C3 122D7942 5FE03A45 DBFE1655");
        BigInteger yPA = SM2Params.fromHex("3DF79E8D AC1CF0EC BAA2F2B4 9D51A4B3 87F2EFAF 48233908 6A27A8E0 5BAED98B");
        ECPoint PA = spec.getCurve().createPoint(xPA, yPA);
        BigInteger rA = SM2Params.fromHex("83A2C9C8 B96E5AF7 0BD480B4 72409A9A 327257F1 EBB73F5B 073354B2 48668563");
        BigInteger xRA = SM2Params.fromHex("6CB56338 16F4DD56 0B1DEC45 8310CBCC 6856C095 05324A6D 23150C40 8F162BF0");
        BigInteger yRA = SM2Params.fromHex("0D6FCF62 F1036C0A 1B6DACCF 57399223 A65F7D7B F2D9637E 5BBBEB85 7961BF1A");
        ECPoint RA = spec.getCurve().createPoint(xRA, yRA);
        BigInteger dB = SM2Params.fromHex("5E35D7D3 F3C54DBA C72E6181 9E730B01 9A84208C A3A35E4C 2E353DFC CB2A3B53");
        BigInteger xPB = SM2Params.fromHex("245493D4 46C38D8C C0F11837 4690E7DF 633A8A4B FB3329B5 ECE604B2 B4F37F43");
        BigInteger yPB = SM2Params.fromHex("53C0869F 4B9E1777 3DE68FEC 45E14904 E0DEA45B F6CECF99 18C85EA0 47C60A4C");
        ECPoint PB = spec.getCurve().createPoint(xPB, yPB);
        BigInteger rB = SM2Params.fromHex("33FE2194 0342161C 55619C4A 0C060293 D543C80A F19748CE 176D8347 7DE71C80");
        BigInteger xRB = SM2Params.fromHex("1799B2A2 C7782953 00D9A232 5C686129 B8F2B533 7B3DCF45 14E8BBC1 9D900EE5");
        BigInteger yRB = SM2Params.fromHex("54C9288C 82733EFD F7808AE7 F27D0E73 2F7C73A7 D9AC98B7 D8740A91 D0DB3CF4");
        ECPoint RB = spec.getCurve().createPoint(xRB, yRB);
        BigInteger X = SM2Params.fromHex("47C82653 4DC2F6F1 FBF28728 DD658F21 E174F481 79ACEF29 00F8B7F5 66E40905");
        BigInteger Y = SM2Params.fromHex("2AF86EFE 732CF12A D0E09A1F 2556CC65 0D9CCCE3 E249866B BB5C6846 A4C4A295");
        ECPoint U = spec.getCurve().createPoint(X, Y);
        ECPrivateKeyParameters dAParam = null;
        ECPublicKeyParameters PAParam = null;
        ECPrivateKeyParameters rAParam = null;
        ECPublicKeyParameters RAParam = null;
        ECPrivateKeyParameters dBParam = null;
        ECPublicKeyParameters PBParam = null;
        ECPrivateKeyParameters rBParam = null;
        ECPublicKeyParameters RBParam = null;
        dAParam = new ECPrivateKeyParameters(dA, params);
        PAParam = new ECPublicKeyParameters(PA, params);
        rAParam = new ECPrivateKeyParameters(rA, params);
        RAParam = new ECPublicKeyParameters(RA, params);
        dBParam = new ECPrivateKeyParameters(dB, params);
        PBParam = new ECPublicKeyParameters(PB, params);
        rBParam = new ECPrivateKeyParameters(rB, params);
        RBParam = new ECPublicKeyParameters(RB, params);
        MQVPrivateParameters priAParams = null;
        MQVPrivateParameters priBParams = null;
        MQVPublicParameters pubAParams = null;
        MQVPublicParameters pubBParams = null;
        priAParams = new MQVPrivateParameters(dAParam, rAParam, RAParam);
        priBParams = new MQVPrivateParameters(dBParam, rBParam, RBParam);
        pubAParams = new MQVPublicParameters(PAParam, RAParam);
        pubBParams = new MQVPublicParameters(PBParam, RBParam);
        SM2MQVBasicAgreement agreement = new SM2MQVBasicAgreement();
        agreement.init(priAParams);
        ECPoint QA = agreement.calculateMqvAgreement(pubBParams);
        System.err.println(QA.getXCoord().toBigInteger().toString(16));
        System.err.println(QA.getYCoord().toBigInteger().toString(16));
        agreement = new SM2MQVBasicAgreement();
        agreement.init(priBParams);
        ECPoint QB = agreement.calculateMqvAgreement(pubAParams);
        System.err.println(QB.getXCoord().toBigInteger().toString(16));
        System.err.println(QB.getYCoord().toBigInteger().toString(16));
        System.err.println(U.equals(QA));
        System.err.println(U.equals(QB));
        ProviderConfiguration configuration = BouncyCastleProvider.CONFIGURATION;
        MQVPrivateKeySpec mqvPrivKey = new MQVPrivateKeySpec(new BCECPrivateKey("SM2", dAParam, configuration), new BCECPrivateKey("SM2", rAParam, configuration), new BCECPublicKey("SM2", RAParam, configuration));
        MQVPublicKeySpec mqvPubKey = new MQVPublicKeySpec(new BCECPublicKey("SM2", PBParam, configuration), new BCECPublicKey("SM2", RBParam, configuration));
        KeyAgreement ka = KeyAgreement.getInstance("SM2");
        SecureRandom paramAlgorithmParameterSpec = null;
        ka.init((Key)mqvPrivKey, paramAlgorithmParameterSpec);
        ka.doPhase(mqvPubKey, true);
        SecretKey xx = ka.generateSecret("TlsPremasterSecret");
        System.err.println(xx);
    }
}

