/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.PasswordRecipientInfoGenerator;
import msfpay.cfca.sadk.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import msfpay.cfca.sadk.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import msfpay.cfca.sadk.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import msfpay.cfca.sadk.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import msfpay.cfca.sadk.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.operator.GenericKey;

public class JcePasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());

    public JcePasswordRecipientInfoGenerator(ASN1ObjectIdentifier kekAlgorithm, char[] password) {
        super(kekAlgorithm, password);
    }

    public JcePasswordRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JcePasswordRecipientInfoGenerator setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    protected byte[] calculateDerivedKey(byte[] encodedPassword, AlgorithmIdentifier derivationAlgorithm, int keySize) throws CMSException {
        PBKDF2Params params = PBKDF2Params.getInstance(derivationAlgorithm.getParameters());
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(encodedPassword, params.getSalt(), params.getIterationCount().intValue());
        return ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
    }

    public byte[] generateEncryptedBytes(AlgorithmIdentifier keyEncryptionAlgorithm, byte[] derivedKey, GenericKey contentEncryptionKey) throws CMSException {
        Key contentEncryptionKeySpec = this.helper.getJceKey(contentEncryptionKey);
        Cipher keyEncryptionCipher = this.helper.createRFC3211Wrapper(keyEncryptionAlgorithm.getAlgorithm());
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ASN1OctetString.getInstance(keyEncryptionAlgorithm.getParameters()).getOctets());
            keyEncryptionCipher.init(3, (Key)new SecretKeySpec(derivedKey, keyEncryptionCipher.getAlgorithm()), ivSpec);
            return keyEncryptionCipher.wrap(contentEncryptionKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("cannot process content encryption key: " + e.getMessage(), e);
        }
    }
}

