/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms.bc;

import java.io.InputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.RecipientOperator;
import msfpay.cfca.sadk.org.bouncycastle.cms.bc.BcKeyTransRecipient;
import msfpay.cfca.sadk.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import msfpay.cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.io.CipherInputStream;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptor;

public class BcRSAKeyTransEnvelopedRecipient
extends BcKeyTransRecipient {
    public BcRSAKeyTransEnvelopedRecipient(AsymmetricKeyParameter key) {
        super(key);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        CipherParameters secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataIn) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataIn, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataIn, (StreamCipher)dataCipher);
            }
        });
    }
}

