/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms.bc;

import java.io.InputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.RecipientOperator;
import msfpay.cfca.sadk.org.bouncycastle.cms.bc.BcKEKRecipient;
import msfpay.cfca.sadk.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import msfpay.cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.io.CipherInputStream;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptor;
import msfpay.cfca.sadk.org.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        super(unwrapper);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = (KeyParameter)this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

