/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Enumeration;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.OriginatorInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.CertificateList;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509CRLHolder;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.util.CollectionStore;
import msfpay.cfca.sadk.org.bouncycastle.util.Store;

public class OriginatorInformation {
    private OriginatorInfo originatorInfo;

    OriginatorInformation(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public Store getCertificates() {
        ASN1Set certSet = this.originatorInfo.getCertificates();
        if (certSet != null) {
            ArrayList<X509CertificateHolder> certList = new ArrayList<X509CertificateHolder>(certSet.size());
            Enumeration en = certSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                certList.add(new X509CertificateHolder(Certificate.getInstance(obj)));
            }
            return new CollectionStore(certList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() {
        ASN1Set crlSet = this.originatorInfo.getCRLs();
        if (crlSet != null) {
            ArrayList<X509CRLHolder> crlList = new ArrayList<X509CRLHolder>(crlSet.size());
            Enumeration en = crlSet.getObjects();
            while (en.hasMoreElements()) {
                ASN1Primitive obj = ((ASN1Encodable)en.nextElement()).toASN1Primitive();
                if (!(obj instanceof ASN1Sequence)) continue;
                crlList.add(new X509CRLHolder(CertificateList.getInstance(obj)));
            }
            return new CollectionStore(crlList);
        }
        return new CollectionStore(new ArrayList());
    }

    public OriginatorInfo toASN1Structure() {
        return this.originatorInfo;
    }
}

