/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.math.BigInteger;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import msfpay.cfca.sadk.org.bouncycastle.cms.KeyTransRecipientInformation;
import msfpay.cfca.sadk.org.bouncycastle.cms.RecipientId;

public class KeyTransRecipientId
extends RecipientId {
    private X509CertificateHolderSelector baseSelector;

    private KeyTransRecipientId(X509CertificateHolderSelector baseSelector) {
        super(0);
        this.baseSelector = baseSelector;
    }

    public KeyTransRecipientId(byte[] subjectKeyId) {
        this(null, null, subjectKeyId);
    }

    public KeyTransRecipientId(X500Name issuer, BigInteger serialNumber) {
        this(issuer, serialNumber, null);
    }

    public KeyTransRecipientId(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        this(new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId));
    }

    public X500Name getIssuer() {
        return this.baseSelector.getIssuer();
    }

    public BigInteger getSerialNumber() {
        return this.baseSelector.getSerialNumber();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.baseSelector.getSubjectKeyIdentifier();
    }

    public int hashCode() {
        return this.baseSelector.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyTransRecipientId)) {
            return false;
        }
        KeyTransRecipientId id = (KeyTransRecipientId)o;
        return this.baseSelector.equals(id.baseSelector);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean match(Object obj) {
        if (obj instanceof KeyTransRecipientInformation) {
            return ((KeyTransRecipientInformation)obj).getRID().equals(this);
        }
        return this.baseSelector.match(obj);
    }

    public static void test(String[] args) {
        KeyTransRecipientId x = new KeyTransRecipientId(new byte[8]);
        System.err.println(x);
        System.err.println(x.clone());
        System.err.println(x.clone().equals(x));
        System.err.println(x.baseSelector.equals(((KeyTransRecipientId)x.clone()).baseSelector));
        X500Name issuer = new X500Name("C=DD,CN=TT");
        BigInteger serialNumber = new BigInteger("1");
        byte[] subjectKeyId = "xxxx".getBytes();
        X509CertificateHolderSelector selector = new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId);
        x = new KeyTransRecipientId(selector);
        System.err.println(x);
        System.err.println(x.clone());
        System.err.println(x.clone().equals(x));
    }
}

