/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.math.BigInteger;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import msfpay.cfca.sadk.org.bouncycastle.cms.KeyAgreeRecipientInformation;
import msfpay.cfca.sadk.org.bouncycastle.cms.RecipientId;

public class KeyAgreeRecipientId
extends RecipientId {
    private X509CertificateHolderSelector baseSelector;

    private KeyAgreeRecipientId(X509CertificateHolderSelector baseSelector) {
        super(2);
        this.baseSelector = baseSelector;
    }

    public KeyAgreeRecipientId(byte[] subjectKeyId) {
        this(null, null, subjectKeyId);
    }

    public KeyAgreeRecipientId(X500Name issuer, BigInteger serialNumber) {
        this(issuer, serialNumber, null);
    }

    public KeyAgreeRecipientId(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        this(new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId));
    }

    public BigInteger getSerialNumber() {
        return this.baseSelector.getSerialNumber();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.baseSelector.getSubjectKeyIdentifier();
    }

    public int hashCode() {
        return this.baseSelector.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyAgreeRecipientId)) {
            return false;
        }
        KeyAgreeRecipientId id = (KeyAgreeRecipientId)o;
        return this.baseSelector.equals(id.baseSelector);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean match(Object obj) {
        if (obj instanceof KeyAgreeRecipientInformation) {
            return this.equals(((KeyAgreeRecipientInformation)obj).getRID());
        }
        return this.baseSelector.match(obj);
    }

    public static void test(String[] args) {
        KeyAgreeRecipientId x = new KeyAgreeRecipientId(new byte[8]);
        System.err.println(x);
        System.err.println(x.clone());
        System.err.println(x.clone().equals(x));
        X500Name issuer = new X500Name("C=DD,CN=TT");
        BigInteger serialNumber = new BigInteger("1");
        byte[] subjectKeyId = "xxxx".getBytes();
        X509CertificateHolderSelector selector = new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId);
        x = new KeyAgreeRecipientId(selector);
        System.err.println(x);
        System.err.println(x.clone());
        System.err.println(x.clone().equals(x));
    }
}

