/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import msfpay.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.KEKIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.RecipientInfoGenerator;
import msfpay.cfca.sadk.org.bouncycastle.operator.GenericKey;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorException;
import msfpay.cfca.sadk.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

