/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BEROctetStringGenerator;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BERSet;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSet;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponse;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509AttributeCertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509CRLHolder;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.NullOutputStream;
import msfpay.cfca.sadk.org.bouncycastle.cms.SignerInfoGenerator;
import msfpay.cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import msfpay.cfca.sadk.org.bouncycastle.util.Store;
import msfpay.cfca.sadk.org.bouncycastle.util.Strings;
import msfpay.cfca.sadk.org.bouncycastle.util.io.Streams;
import msfpay.cfca.sadk.org.bouncycastle.util.io.TeeInputStream;
import msfpay.cfca.sadk.org.bouncycastle.util.io.TeeOutputStream;

class CMSUtils {
    CMSUtils() {
    }

    static ContentInfo readContentInfo(byte[] input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static ContentInfo readContentInfo(InputStream input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static List getCertificatesFromStore(Store certStore) throws CMSException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            Iterator it = certStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509CertificateHolder c = (X509CertificateHolder)it.next();
                certs.add(c.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getAttributeCertificatesFromStore(Store attrStore) throws CMSException {
        ArrayList<DERTaggedObject> certs = new ArrayList<DERTaggedObject>();
        try {
            Iterator it = attrStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509AttributeCertificateHolder attrCert = (X509AttributeCertificateHolder)it.next();
                certs.add(new DERTaggedObject(false, 2, attrCert.toASN1Structure()));
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getCRLsFromStore(Store crlStore) throws CMSException {
        ArrayList<ASN1Object> crls = new ArrayList<ASN1Object>();
        try {
            Iterator it = crlStore.getMatches(null).iterator();
            while (it.hasNext()) {
                Object rev = it.next();
                if (rev instanceof X509CRLHolder) {
                    X509CRLHolder c = (X509CRLHolder)rev;
                    crls.add(c.toASN1Structure());
                    continue;
                }
                if (rev instanceof OtherRevocationInfoFormat) {
                    OtherRevocationInfoFormat infoFormat = OtherRevocationInfoFormat.getInstance(rev);
                    CMSUtils.validateInfoFormat(infoFormat);
                    crls.add(new DERTaggedObject(false, 1, infoFormat));
                    continue;
                }
                if (!(rev instanceof ASN1TaggedObject)) continue;
                crls.add((ASN1Object)rev);
            }
            return crls;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    private static void validateInfoFormat(OtherRevocationInfoFormat infoFormat) {
        OCSPResponse resp;
        if (CMSObjectIdentifiers.id_ri_ocsp_response.equals(infoFormat.getInfoFormat()) && (resp = OCSPResponse.getInstance(infoFormat.getInfo())).getResponseStatus().getValue().intValue() != 0) {
            throw new IllegalArgumentException("cannot add unsuccessful OCSP response to CMS SignedData");
        }
    }

    static Collection getOthersFromStore(ASN1ObjectIdentifier otherRevocationInfoFormat, Store otherRevocationInfos) {
        ArrayList<DERTaggedObject> others = new ArrayList<DERTaggedObject>();
        Iterator it = otherRevocationInfos.getMatches(null).iterator();
        while (it.hasNext()) {
            ASN1Encodable info = (ASN1Encodable)it.next();
            OtherRevocationInfoFormat infoFormat = new OtherRevocationInfoFormat(otherRevocationInfoFormat, info);
            CMSUtils.validateInfoFormat(infoFormat);
            others.add(new DERTaggedObject(false, 1, infoFormat));
        }
        return others;
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new BERSet(v);
    }

    static ASN1Set createDerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new DERSet(v);
    }

    static OutputStream createBEROctetOutputStream(OutputStream s, int tagNo, boolean isExplicit, int bufferSize) throws IOException {
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(s, tagNo, isExplicit);
        if (bufferSize != 0) {
            return octGen.getOctetOutputStream(new byte[bufferSize]);
        }
        return octGen.getOctetOutputStream();
    }

    private static ContentInfo readContentInfo(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance(in.readObject());
        }
        catch (IOException e) {
            throw new CMSException("IOException reading content.", e);
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    static byte[] getPasswordBytes(int scheme, char[] password) {
        if (scheme == 0) {
            return CMSUtils.PKCS5PasswordToBytes(password);
        }
        return CMSUtils.PKCS5PasswordToUTF8Bytes(password);
    }

    private static byte[] PKCS5PasswordToBytes(char[] password) {
        if (password != null) {
            byte[] bytes = new byte[password.length];
            for (int i = 0; i != bytes.length; ++i) {
                bytes[i] = (byte)password[i];
            }
            return bytes;
        }
        return new byte[0];
    }

    private static byte[] PKCS5PasswordToUTF8Bytes(char[] password) {
        if (password != null) {
            return Strings.toUTF8ByteArray(password);
        }
        return new byte[0];
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        return Streams.readAll(in);
    }

    public static byte[] streamToByteArray(InputStream in, int limit) throws IOException {
        return Streams.readAllLimited(in, limit);
    }

    static InputStream attachDigestsToInputStream(Collection digests, InputStream s) {
        InputStream result = s;
        Iterator it = digests.iterator();
        while (it.hasNext()) {
            DigestCalculator digest = (DigestCalculator)it.next();
            result = new TeeInputStream(result, digest.getOutputStream());
        }
        return result;
    }

    static OutputStream attachSignersToOutputStream(Collection signers, OutputStream s) {
        OutputStream result = s;
        Iterator it = signers.iterator();
        while (it.hasNext()) {
            SignerInfoGenerator signerGen = (SignerInfoGenerator)it.next();
            result = CMSUtils.getSafeTeeOutputStream(result, signerGen.getCalculatingOutputStream());
        }
        return result;
    }

    static OutputStream getSafeOutputStream(OutputStream s) {
        return s == null ? new NullOutputStream() : s;
    }

    static OutputStream getSafeTeeOutputStream(OutputStream s1, OutputStream s2) {
        return s1 == null ? CMSUtils.getSafeOutputStream(s2) : (s2 == null ? CMSUtils.getSafeOutputStream(s1) : new TeeOutputStream(s1, s2));
    }
}

