/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Generator;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetStringParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1SequenceParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1SetParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1StreamParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BERSequenceGenerator;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BERSetParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BERTaggedObject;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSet;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfoParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.SignedDataParser;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.SignerInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSContentInfoParser;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSSignedHelper;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSTypedStream;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSUtils;
import msfpay.cfca.sadk.org.bouncycastle.cms.SignerInformation;
import msfpay.cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import msfpay.cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import msfpay.cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import msfpay.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import msfpay.cfca.sadk.org.bouncycastle.util.Store;
import msfpay.cfca.sadk.org.bouncycastle.util.io.Streams;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map digests;
    private SignerInformationStore _signerInfoStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, byte[] sigBlock) throws CMSException {
        this(digestCalculatorProvider, signedContent, new ByteArrayInputStream(sigBlock));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream sigData) throws CMSException {
        this(digestCalculatorProvider, null, sigData);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream signedContent, InputStream sigData) throws CMSException {
        super(sigData);
        try {
            ASN1Encodable o;
            this._signedContent = signedContent;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this.digests = new HashMap();
            ASN1SetParser digAlgs = this._signedData.getDigestAlgorithms();
            while ((o = digAlgs.readObject()) != null) {
                AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance(o);
                try {
                    DigestCalculator calculator = digestCalculatorProvider.get(algId);
                    if (calculator == null) continue;
                    this.digests.put(algId.getAlgorithm(), calculator);
                }
                catch (OperatorCreationException e) {}
            }
            ContentInfoParser cont = this._signedData.getEncapContentInfo();
            ASN1OctetStringParser octs = (ASN1OctetStringParser)cont.getContent(4);
            if (octs != null) {
                CMSTypedStream ctStr = new CMSTypedStream(cont.getContentType().getId(), octs.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = ctStr;
                } else {
                    ctStr.drain();
                }
            }
            this._signedContentType = signedContent == null ? cont.getContentType() : this._signedContent.getContentType();
        }
        catch (IOException e) {
            throw new CMSException("io exception: " + e.getMessage(), e);
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            HashMap hashes = new HashMap();
            Iterator it = this.digests.keySet().iterator();
            while (it.hasNext()) {
                Object digestKey = it.next();
                hashes.put(digestKey, ((DigestCalculator)this.digests.get(digestKey)).getDigest());
            }
            try {
                ASN1Encodable o;
                ASN1SetParser s = this._signedData.getSignerInfos();
                while ((o = s.readObject()) != null) {
                    SignerInfo info = SignerInfo.getInstance(o.toASN1Primitive());
                    byte[] hash = (byte[])hashes.get(info.getDigestAlgorithm().getAlgorithm());
                    signerInfos.add(new SignerInformation(info, this._signedContentType, null, hash));
                }
            }
            catch (IOException e) {
                throw new CMSException("io exception: " + e.getMessage(), e);
            }
            this._signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this._signerInfoStore;
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        return HELPER.getCertificates(this._certSet);
    }

    public Store getCRLs() throws CMSException {
        this.populateCertCrlSets();
        return HELPER.getCRLs(this._crlSet);
    }

    public Store getAttributeCertificates() throws CMSException {
        this.populateCertCrlSets();
        return HELPER.getAttributeCertificates(this._certSet);
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat) throws CMSException {
        this.populateCertCrlSets();
        return HELPER.getOtherRevocationInfo(otherRevocationInfoFormat, this._crlSet);
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
        }
        catch (IOException e) {
            throw new CMSException("problem parsing cert/crl sets", e);
        }
    }

    public String getSignedContentTypeOID() {
        return this._signedContentType.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream digStream = CMSUtils.attachDigestsToInputStream(this.digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), digStream);
    }

    public static OutputStream replaceSigners(InputStream original, SignerInformationStore signerInformationStore, OutputStream out) throws CMSException, IOException {
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        signedData.getDigestAlgorithms().toASN1Primitive();
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        Iterator it = signerInformationStore.getSigners().iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCertificates(), 0);
        CMSSignedDataParser.writeSetToGeneratorTagged(sigGen, signedData.getCrls(), 1);
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        Iterator it2 = signerInformationStore.getSigners().iterator();
        while (it2.hasNext()) {
            SignerInformation signer = (SignerInformation)it2.next();
            signerInfos.add(signer.toASN1Structure());
        }
        sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream original, Store certs, Store crls, Store attrCerts, OutputStream out) throws CMSException, IOException {
        ASN1Set asn1Crls;
        ASN1StreamParser in = new ASN1StreamParser(original);
        ContentInfoParser contentInfo = new ContentInfoParser((ASN1SequenceParser)in.readObject());
        SignedDataParser signedData = SignedDataParser.getInstance(contentInfo.getContent(16));
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(signedData.getVersion());
        sigGen.getRawOutputStream().write(signedData.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser encapContentInfo = signedData.getEncapContentInfo();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(encapContentInfo.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(encapContentInfo, eiGen.getRawOutputStream());
        eiGen.close();
        CMSSignedDataParser.getASN1Set(signedData.getCertificates());
        CMSSignedDataParser.getASN1Set(signedData.getCrls());
        if (certs != null || attrCerts != null) {
            ASN1Set asn1Certs;
            ArrayList certificates = new ArrayList();
            if (certs != null) {
                certificates.addAll(CMSUtils.getCertificatesFromStore(certs));
            }
            if (attrCerts != null) {
                certificates.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((asn1Certs = CMSUtils.createBerSetFromList(certificates)).size() > 0) {
                sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, asn1Certs).getEncoded());
            }
        }
        if (crls != null && (asn1Crls = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(crls))).size() > 0) {
            sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, asn1Crls).getEncoded());
        }
        sigGen.getRawOutputStream().write(signedData.getSignerInfos().toASN1Primitive().getEncoded());
        sigGen.close();
        sGen.close();
        return out;
    }

    private static void writeSetToGeneratorTagged(ASN1Generator asn1Gen, ASN1SetParser asn1SetParser, int tagNo) throws IOException {
        ASN1Set asn1Set = CMSSignedDataParser.getASN1Set(asn1SetParser);
        if (asn1Set != null) {
            if (asn1SetParser instanceof BERSetParser) {
                asn1Gen.getRawOutputStream().write(new BERTaggedObject(false, tagNo, asn1Set).getEncoded());
            } else {
                asn1Gen.getRawOutputStream().write(new DERTaggedObject(false, tagNo, asn1Set).getEncoded());
            }
        }
    }

    private static ASN1Set getASN1Set(ASN1SetParser asn1SetParser) {
        return asn1SetParser == null ? null : ASN1Set.getInstance(asn1SetParser.toASN1Primitive());
    }

    private static void pipeEncapsulatedOctetString(ContentInfoParser encapContentInfo, OutputStream rawOutputStream) throws IOException {
        ASN1OctetStringParser octs = (ASN1OctetStringParser)encapContentInfo.getContent(4);
        if (octs != null) {
            CMSSignedDataParser.pipeOctetString(octs, rawOutputStream);
        }
    }

    private static void pipeOctetString(ASN1OctetStringParser octs, OutputStream output) throws IOException {
        OutputStream outOctets = CMSUtils.createBEROctetOutputStream(output, 0, true, 0);
        Streams.pipeAll(octs.getOctetStream(), outOctets);
        outOctets.close();
    }
}

