/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EncryptedData;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSTypedStream;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSUtils;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptor;
import msfpay.cfca.sadk.org.bouncycastle.operator.InputDecryptorProvider;

public class CMSEncryptedData {
    private ContentInfo contentInfo;
    private EncryptedData encryptedData;

    public CMSEncryptedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        this.encryptedData = EncryptedData.getInstance(contentInfo.getContent());
    }

    public byte[] getContent(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            return CMSUtils.streamToByteArray(this.getContentStream(inputDecryptorProvider).getContentStream());
        }
        catch (IOException e) {
            throw new CMSException("unable to parse internal stream: " + e.getMessage(), e);
        }
    }

    public CMSTypedStream getContentStream(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            EncryptedContentInfo encContentInfo = this.encryptedData.getEncryptedContentInfo();
            InputDecryptor decrytor = inputDecryptorProvider.get(encContentInfo.getContentEncryptionAlgorithm());
            ByteArrayInputStream encIn = new ByteArrayInputStream(encContentInfo.getEncryptedContent().getOctets());
            return new CMSTypedStream(encContentInfo.getContentType(), decrytor.getInputStream(encIn));
        }
        catch (Exception e) {
            throw new CMSException("unable to create stream: " + e.getMessage(), e);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }
}

