/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cert.jcajce;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import msfpay.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import msfpay.cfca.sadk.org.bouncycastle.util.CollectionStore;

public class JcaCertStore
extends CollectionStore {
    public JcaCertStore(Collection collection) throws CertificateEncodingException {
        super(JcaCertStore.convertCerts(collection));
    }

    private static Collection convertCerts(Collection collection) throws CertificateEncodingException {
        ArrayList<X509CertificateHolder> list = new ArrayList<X509CertificateHolder>(collection.size());
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)o;
                try {
                    list.add(new X509CertificateHolder(cert.getEncoded()));
                    continue;
                }
                catch (IOException e) {
                    throw new CertificateEncodingException("unable to read encoding: " + e.getMessage());
                }
            }
            if (o instanceof Certificate) {
                Certificate certificate = (Certificate)o;
                try {
                    list.add(new X509CertificateHolder(certificate.getEncoded()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            list.add((X509CertificateHolder)o);
        }
        return list;
    }
}

