/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.cert.crmf;

import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import msfpay.cfca.sadk.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.crmf.EncryptedKey;
import msfpay.cfca.sadk.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import msfpay.cfca.sadk.org.bouncycastle.cert.crmf.CRMFException;
import msfpay.cfca.sadk.org.bouncycastle.cert.crmf.Control;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier type = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions pkiArchiveOptions;

    public PKIArchiveControl(PKIArchiveOptions pkiArchiveOptions) {
        this.pkiArchiveOptions = pkiArchiveOptions;
    }

    public ASN1ObjectIdentifier getType() {
        return type;
    }

    public ASN1Encodable getValue() {
        return this.pkiArchiveOptions;
    }

    public int getArchiveType() {
        return this.pkiArchiveOptions.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
        return !encKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() throws CRMFException {
        try {
            EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
            EnvelopedData data = EnvelopedData.getInstance(encKey.getValue());
            return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, data));
        }
        catch (CMSException e) {
            throw new CRMFException("CMS parsing error: " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new CRMFException("CRMF parsing error: " + e.getMessage(), e);
        }
    }
}

