/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp;

import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AuthorityInformationAccess;

public class ServiceLocator
extends ASN1Object {
    X500Name issuer;
    AuthorityInformationAccess locator;

    public ServiceLocator(X500Name issuer, AuthorityInformationAccess locator) {
        this.issuer = issuer;
        this.locator = locator;
    }

    private ServiceLocator(ASN1Sequence seq) {
        this.issuer = X500Name.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.locator = AuthorityInformationAccess.getInstance(seq.getObjectAt(1));
        }
    }

    public static ServiceLocator getInstance(Object obj) {
        if (obj instanceof ServiceLocator) {
            return (ServiceLocator)obj;
        }
        if (obj != null) {
            return new ServiceLocator(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public AuthorityInformationAccess getLocator() {
        return this.locator;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer);
        if (this.locator != null) {
            v.add(this.locator);
        }
        return new DERSequence(v);
    }
}

