/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.asn1;

import java.io.IOException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1String;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import msfpay.cfca.sadk.org.bouncycastle.asn1.StreamUtil;
import msfpay.cfca.sadk.org.bouncycastle.util.Arrays;
import msfpay.cfca.sadk.org.bouncycastle.util.Strings;

public class DERGeneralString
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERGeneralString getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralString) {
            return (DERGeneralString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERGeneralString)DERGeneralString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERGeneralString) {
            return DERGeneralString.getInstance(o);
        }
        return new DERGeneralString(((ASN1OctetString)o).getOctets());
    }

    DERGeneralString(byte[] string) {
        this.string = string;
    }

    public DERGeneralString(String string) {
        this.string = Strings.toByteArray(string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    public boolean isConstructed() {
        return false;
    }

    public int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(27, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    public boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString s = (DERGeneralString)o;
        return Arrays.areEqual(this.string, s.string);
    }
}

