/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.lib.crypto.hard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import msfpay.cfca.sadk.algorithm.common.CBCParam;
import msfpay.cfca.sadk.algorithm.common.GenKeyAttribute;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.util.HashEncoderUtil;
import msfpay.cfca.sadk.lib.crypto.JCrypto;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.signature.rsa.RSAPackageUtil;
import msfpay.cfca.sadk.system.Mechanisms;
import msfpay.cfca.sadk.system.global.FileAndBufferConfig;
import msfpay.cfca.sadk.util.EncryptUtil;

public class HardLib
implements Session {
    private static String signByHash_ALG = "SimuSM2";
    private String providerName;
    private Provider provider;

    public HardLib(String providerPath) throws PKIException {
        if (providerPath == null || providerPath.trim().equals("")) {
            providerPath = "com.sansec.jce.provider.SwxaProvider";
        }
        try {
            this.provider = (Provider)Class.forName(providerPath).newInstance();
            this.providerName = this.provider.getName();
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + this.providerName, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.provider);
            signature.initSign(priKey);
            signature.update(sourceData);
            signData = signature.sign();
            return signData;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        String mType = mechanism.getMechanismType();
        byte[] signData = null;
        InputStream sourceData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.provider);
            signature.initSign(priKey);
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(sourceStream);
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            byte[] byArray = signData = signature.sign();
            return byArray;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    throw new PKIException("Signed failure", e);
                }
            }
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                pubKey = this.getSM2HardPublicKey(pubKey);
            }
            signature.initVerify(pubKey);
            signature.update(sourceData);
            return signature.verify(signData);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, ex);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        InputStream sourceData = null;
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                pubKey = this.getSM2HardPublicKey(pubKey);
            }
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
            signature.initVerify(pubKey);
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(sourceStream);
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            boolean bl = signature.verify(signData);
            return bl;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    throw new PKIException("Verified failure", e);
                }
            }
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        String mType = mechanism.getMechanismType();
        int cipherMode = 1;
        try {
            Cipher cipher = Cipher.getInstance(mType, this.provider);
            if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, key, iv);
            } else {
                cipher.init(cipherMode, key);
            }
            return cipher.doFinal(sourceData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        String mType = mechanism.getMechanismType();
        int cipherMode = 2;
        try {
            Cipher cipher = Cipher.getInstance(mType, this.provider);
            if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, key, iv);
            } else {
                cipher.init(cipherMode, key);
            }
            return cipher.doFinal(encryptData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        boolean isExport = true;
        int keyNum = 0;
        Object object = mechanism.getParam();
        if (object != null) {
            GenKeyAttribute attr = (GenKeyAttribute)object;
            isExport = attr.isExport;
            if (!isExport) {
                keyNum = attr.keyNum;
            }
        }
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, this.provider);
            if (isExport) {
                keyPairGen.initialize(keyLength);
            } else {
                keyPairGen.initialize(keyNum << 16);
            }
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new PKIException(PKIException.HARD_KEY_PAIR, PKIException.HARD_KEY_PAIR_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        int cipherMode = 1;
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(signByHash_ALG, this.provider);
                signature.initSign(priKey);
                signature.update(digest);
                return signature.sign();
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
            cipher.init(cipherMode, priKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism.getMechanismType(), digest);
            return cipher.doFinal(derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        int cipherMode = 2;
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(signByHash_ALG, this.provider);
                pubKey = this.getSM2HardPublicKey(pubKey);
                signature.initVerify(pubKey);
                signature.update(digest);
                return signature.verify(signData);
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
            cipher.init(cipherMode, pubKey);
            byte[] extractHash = cipher.doFinal(signData);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, digest);
            return RSAPackageUtil.isRSAHashEqual(extractHash, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    private PublicKey getSM2HardPublicKey(PublicKey publicKey) throws PKIException {
        PublicKey pubKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("SM2", this.provider);
            X509EncodedKeySpec x509spec = new X509EncodedKeySpec(publicKey.getEncoded());
            pubKey = kf.generatePublic(x509spec);
            return pubKey;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.COV_PUB_KEY, PKIException.COV_PUB_KEY_DES, ex);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        try {
            this.doCipher(true, encryptAlg, key, sourceStream, encryptStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt failure", e);
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        try {
            this.doCipher(false, encryptAlg, key, encryptStream, plainTextStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt failure", e);
        }
    }

    private void doCipher(boolean isEncrypt, Mechanism encryptAlg, Key key, InputStream input, OutputStream output) throws PKIException {
        try {
            String mType = encryptAlg.getMechanismType();
            int cipherMode = 0;
            Cipher cipher = Cipher.getInstance(mType, this.provider);
            cipherMode = isEncrypt ? 1 : 2;
            if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)encryptAlg.getParam();
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(cipherMode, key, iv);
            } else {
                cipher.init(cipherMode, key);
            }
            int bufferSize = 0x100000;
            byte[] buffer = new byte[bufferSize];
            if (isEncrypt) {
                CipherOutputStream cipherOutStream = new CipherOutputStream(output, cipher);
                BufferedOutputStream bufferOS = new BufferedOutputStream(cipherOutStream, bufferSize);
                BufferedInputStream bufferIS = new BufferedInputStream(input, bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            } else {
                BufferedOutputStream bufferOS = new BufferedOutputStream(output, bufferSize);
                CipherInputStream cipherInputStream = new CipherInputStream(input, cipher);
                BufferedInputStream bufferIS = new BufferedInputStream(cipherInputStream, bufferSize);
                int len = 0;
                while ((len = bufferIS.read(buffer)) > 0) {
                    bufferOS.write(buffer, 0, len);
                }
                bufferOS.close();
                bufferIS.close();
            }
        }
        catch (Exception e) {
            throw new PKIException("Encrypt/Decrypt failure", e);
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        KeyGenerator keyGen;
        String type = keyType.getMechanismType();
        int len = 0;
        if (type.equals("RC4")) {
            len = 128;
        } else if (type.equals("DESede")) {
            len = 192;
        } else if (type.equals("SM4")) {
            len = 128;
        } else {
            throw new PKIException("do not support this key type:" + type);
        }
        try {
            keyGen = KeyGenerator.getInstance(type, this.provider);
            keyGen.init(len);
        }
        catch (Exception e) {
            throw new PKIException("KeyGenerator init failure", e);
        }
        return keyGen.generateKey();
    }

    public static void main(String[] args) throws Exception {
        byte[] keyData = new byte[16];
        SecretKeySpec key = new SecretKeySpec(keyData, "DeSede");
        JCrypto.getInstance().initialize("JNISOFT_LIB", null);
        Session session_jni = JCrypto.getInstance().openSession("JNISOFT_LIB");
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session_soft = JCrypto.getInstance().openSession("JSOFT_LIB");
        EncryptUtil.encrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip", "E:/TestData/BCProvider_PKIX.zip.enen.zip", session_soft);
        EncryptUtil.decrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip.enen.zip", "E:/TestData/BCProvider_PKIX.zip.dede_softjni.zip", session_jni);
        EncryptUtil.encrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip", "E:/TestData/BCProvider_PKIX.zip.enen.zip", session_jni);
        EncryptUtil.decrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip.enen.zip", "E:/TestData/BCProvider_PKIX.zip.dede_jnisoft.zip", session_soft);
        EncryptUtil.encrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip", "E:/TestData/BCProvider_PKIX.zip.enen.zip", session_jni);
        EncryptUtil.decrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip.enen.zip", "E:/TestData/BCProvider_PKIX.zip.dede_jnijni.zip", session_jni);
        EncryptUtil.encrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip", "E:/TestData/BCProvider_PKIX.zip.enen.zip", session_soft);
        EncryptUtil.decrypt(new Mechanism("DESede/ECB/PKCS7Padding"), (Key)key, "E:/TestData/BCProvider_PKIX.zip.enen.zip", "E:/TestData/BCProvider_PKIX.zip.dede_softsoft.zip", session_soft);
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        return null;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getProviderName() {
        return this.providerName;
    }
}

