/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.lib.crypto.bcsoft;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import msfpay.cfca.sadk.algorithm.sm2.SM2PublicKey;
import msfpay.cfca.sadk.algorithm.util.BigFileCipherUtil;
import msfpay.cfca.sadk.algorithm.util.HashEncoderUtil;
import msfpay.cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.jcajce.asymmetric.keypair.SM2KeyPairGenerator;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import msfpay.cfca.sadk.signature.rsa.RSAPackageUtil;
import msfpay.cfca.sadk.signature.sm2.SM2PackageUtil;
import msfpay.cfca.sadk.system.CompatibleAlgorithm;
import msfpay.cfca.sadk.system.Mechanisms;
import msfpay.cfca.sadk.system.global.SM2ContextConfig;
import msfpay.cfca.sadk.util.HashUtil;

public class BCSoftLib
implements Session {
    public KeyPair generateKeyPair(Mechanism keyType, int keyLength) throws PKIException {
        try {
            if (Mechanisms.isSM2Type(keyType)) {
                SM2KeyPairGenerator generator = new SM2KeyPairGenerator();
                generator.initialize(256, new SecureRandom());
                return generator.generateKeyPair();
            }
            if (Mechanisms.isRSAType(keyType)) {
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("RSA");
                }
                catch (Exception e) {
                    return null;
                }
                if (keyLength <= 0 || keyLength > 4096) {
                    throw new PKIException("key length is illgal:" + keyLength);
                }
                keyPairGen.initialize(keyLength);
                KeyPair keyPair = keyPairGen.generateKeyPair();
                return keyPair;
            }
            throw new PKIException(PKIException.BC_KEY_PAIR, PKIException.BC_KEY_PAIR_DES + " " + PKIException.NOT_SUP_DES + keyType.getMechanismType());
        }
        catch (Exception e) {
            throw new PKIException("GenerateKeyPair Failure", e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        if (sourceData == null) {
            throw new PKIException("the source data is null!");
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = new byte[32];
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    this.SM2HashMessage(sm2PubKey, true, sourceData, hash);
                } else {
                    this.SM2HashMessage(sm2PubKey, false, sourceData, hash);
                }
                return SM2PackageUtil.encryptByBC(hash, sm2priKey);
            }
            byte[] out = HashUtil.RSAHashMessageByBC(sourceData, mechanism, true);
            return RSAPackageUtil.encrypt(out, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = new byte[32];
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    this.SM2HashFile(sm2PubKey, true, sourceStream, hash);
                } else {
                    this.SM2HashFile(sm2PubKey, false, sourceStream, hash);
                }
                return SM2PackageUtil.encryptByBC(hash, sm2priKey);
            }
            byte[] digestData = HashUtil.RSAHashFileByBC(sourceStream, mechanism, true);
            return RSAPackageUtil.encrypt(digestData, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] hash = new byte[32];
                this.SM2HashMessage(sm2PubKey, true, sourceData, hash);
                boolean verifyResult = SM2PackageUtil.verifyByBC(hash, signData, pubKey);
                boolean compatible = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatible && !verifyResult) {
                    this.SM2HashMessage(sm2PubKey, false, sourceData, hash);
                    verifyResult = SM2PackageUtil.verifyByBC(hash, signData, pubKey);
                }
                return verifyResult;
            }
            byte[] hashData = HashUtil.RSAHashMessageByBC(sourceData, mechanism, true);
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                boolean compatible = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                byte[] hashWithZ = new byte[32];
                byte[] hashWithoutZ = new byte[32];
                this.SM2HashFile(sm2PubKey, compatible, sourceStream, hashWithZ, hashWithoutZ);
                boolean verifyResult = SM2PackageUtil.verifyByBC(hashWithZ, signData, pubKey);
                if (compatible && !verifyResult) {
                    verifyResult = SM2PackageUtil.verifyByBC(hashWithoutZ, signData, pubKey);
                }
                return verifyResult;
            }
            byte[] hashData = HashUtil.RSAHashFileByBC(sourceStream, mechanism, true);
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(sig, hashData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2Encrypt(true, key, sourceData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(true, key, sourceData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, true, key.getEncoded(), sourceData, mechanism);
            }
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        try {
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                return SM2AndItsCloseSymAlgUtil.sm2Encrypt(false, key, encryptData);
            }
            if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                return RSAAndItsCloseSymAlgUtil.rsaEncrypt(false, key, encryptData);
            }
            if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding") || mType.equals("RC4")) {
                return RSAAndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                return SM2AndItsCloseSymAlgUtil.crypto(false, false, key.getEncoded(), encryptData, mechanism);
            }
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES + " " + PKIException.NOT_SUP_DES + mType);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        if (digest == null) {
            throw new PKIException("the hash data is null!");
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PrivateKey sm2priKey = null;
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                sm2priKey = (SM2PrivateKey)priKey;
                return SM2PackageUtil.encryptByBC(digest, sm2priKey);
            }
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, digest);
            return RSAPackageUtil.encrypt(derDigest, priKey);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        if (!Mechanisms.isValid(mechanism)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + mechanism);
        }
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                return SM2PackageUtil.verifyByBC(digest, signData, pubKey);
            }
            byte[] sig = RSAPackageUtil.decrypt(signData, pubKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, digest);
            return RSAPackageUtil.isRSAHashEqual(sig, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
    }

    public void encrypt(Mechanism encryptAlg, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, encryptAlg, key.getEncoded(), sourceStream, encryptStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt failure", e);
        }
    }

    public void decrypt(Mechanism encryptAlg, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, encryptAlg, key.getEncoded(), encryptStream, plainTextStream);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt failure", e);
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        String type = keyType.getMechanismType();
        SecureRandom random = new SecureRandom();
        if (type.equals("DESede")) {
            byte[] keyData = new byte[24];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("SM4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            byte[] keyData = new byte[16];
            random.nextBytes(keyData);
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        String type = keyType.getMechanismType();
        if ("DESede".equals(type)) {
            if (keyData.length != 24) {
                throw new PKIException("DES3 KEY must be 24 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if ("SM4".equals(type)) {
            if (keyData.length != 16) {
                throw new PKIException("SM4 KEY must be 16 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        if (type.equals("RC4")) {
            if (keyData.length != 16) {
                throw new PKIException("RC4 KEY must be 16 bytes");
            }
            SecretKeySpec key = new SecretKeySpec(keyData, type);
            return key;
        }
        throw new PKIException("do not support this key type:" + type);
    }

    private final void SM2HashFile(SM2PublicKey sm2PubKey, boolean supportedWithoutZ, InputStream stream, byte[] hashWithZ, byte[] hashWithoutZ) throws Exception {
        byte[] buffer = new byte[65536];
        SM3Digest engineWithZ = new SM3Digest();
        engineWithZ.update(sm2PubKey.getDefaultZ(), 0, 32);
        SM3Digest engineWithoutZ = null;
        if (supportedWithoutZ) {
            engineWithoutZ = new SM3Digest();
        }
        int rLength = 0;
        while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
            engineWithZ.update(buffer, 0, rLength);
            if (!supportedWithoutZ) continue;
            engineWithoutZ.update(buffer, 0, rLength);
        }
        engineWithZ.doFinal(hashWithZ, 0);
        if (supportedWithoutZ) {
            engineWithoutZ.doFinal(hashWithoutZ, 0);
        }
    }

    private final void SM2HashFile(SM2PublicKey sm2PubKey, boolean withZ, InputStream stream, byte[] hash) throws Exception {
        byte[] buffer = new byte[65536];
        SM3Digest engine = new SM3Digest();
        if (withZ) {
            engine.update(sm2PubKey.getDefaultZ(), 0, 32);
        }
        int rLength = 0;
        while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
            engine.update(buffer, 0, rLength);
        }
        engine.doFinal(hash, 0);
    }

    private final void SM2HashMessage(SM2PublicKey sm2PubKey, boolean withZ, byte[] message, byte[] hash) {
        SM3Digest engine = new SM3Digest();
        if (withZ) {
            engine.update(sm2PubKey.getDefaultZ(), 0, 32);
        }
        engine.update(message, 0, message.length);
        engine.doFinal(hash, 0);
    }

    public Provider getProvider() {
        return null;
    }

    public String getProviderName() {
        return null;
    }
}

