/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.entity.asn1;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.asn1.pkcs.PKCS12;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public class PFXEntity
extends PKCS12 {
    public PFXEntity() {
    }

    public PFXEntity(String pfxFilePath, String pfxFilePassword) throws IOException, PKIException {
        this.load(pfxFilePath, pfxFilePassword);
    }

    public PFXEntity(InputStream pfxInputStream, String pfxFilePassword) throws IOException, PKIException {
        this.load(pfxInputStream, pfxFilePassword);
    }

    public PFXEntity(byte[] pfxByteData, String pfxFilePassword) throws PKIException {
        this.load(pfxByteData, pfxFilePassword);
    }

    public void load(String pfxFilePath, String pfxFilePassword) throws IOException, PKIException {
        FileInputStream is = new FileInputStream(pfxFilePath);
        this.load(is, pfxFilePassword);
    }

    public void load(InputStream pfxInputStream, String pfxFilePassword) throws IOException, PKIException {
        byte[] pfxByteData = new byte[pfxInputStream.available()];
        pfxInputStream.read(pfxByteData);
        pfxInputStream.close();
        this.load(pfxByteData, pfxFilePassword);
    }

    public void load(byte[] pfxByteData, String pfxFilePassword) throws PKIException {
        super.load(pfxByteData);
        super.decrypt(pfxFilePassword.toCharArray());
    }

    public X509Cert[] getCerts() throws PKIException {
        return super.getCerts();
    }

    public PrivateKey getPrivateKey() throws PKIException {
        return super.getPrivateKey();
    }
}

