/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.entity;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.util.InitKeyStore;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public class JKSEntity {
    private KeyStore keystore;
    private char[] password;

    public JKSEntity(String jksFilePath, String jksFilePwd) throws Exception {
        this.keystore = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
        this.password = jksFilePwd.toCharArray();
    }

    public JKSEntity(InputStream jksInputStream, String jksFilePwd) throws Exception {
        this.keystore = InitKeyStore.initJKSKeyStore(jksInputStream, jksFilePwd);
        this.password = jksFilePwd.toCharArray();
    }

    public PrivateKey getPrivateKey(String alias) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return (PrivateKey)this.keystore.getKey(alias, this.password);
    }

    public X509Cert getCert(String alias) throws KeyStoreException, CertificateEncodingException, PKIException {
        Certificate certificate = this.keystore.getCertificate(alias);
        if (certificate != null) {
            return new X509Cert(certificate.getEncoded());
        }
        throw new PKIException("no such alias cert!");
    }
}

