/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.cgb.toolkit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.PublicKey;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.sm2.SM2PublicKey;
import msfpay.cfca.sadk.algorithm.sm2.SM3Digest;

public final class SM3Toolkit {
    public static final byte[] SM3HashData(byte[] data) throws PKIException {
        return SM3Toolkit.SM3HashData(null, data);
    }

    public static final byte[] SM3HashFile(String filePath) throws PKIException {
        return SM3Toolkit.SM3HashFile(null, filePath);
    }

    public static final byte[] SM3HashData(PublicKey sm2PublicKey, byte[] data) throws PKIException {
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        try {
            byte[] hash = new byte[32];
            SM3Digest engine = new SM3Digest();
            if (sm2PublicKey != null) {
                byte[] zval = ((SM2PublicKey)sm2PublicKey).getDefaultZ();
                engine.update(zval, 0, zval.length);
            }
            engine.update(data, 0, data.length);
            engine.doFinal(hash, 0);
            return hash;
        }
        catch (Exception e) {
            throw new PKIException("hash message failure", e);
        }
    }

    public static final byte[] SM3HashFile(PublicKey sm2PublicKey, String filePath) throws PKIException {
        if (filePath == null) {
            throw new IllegalArgumentException("null not allowed for filePath");
        }
        FileInputStream in = null;
        try {
            int rLength;
            in = new FileInputStream(filePath);
            byte[] hash = new byte[32];
            SM3Digest engine = new SM3Digest();
            if (sm2PublicKey != null) {
                byte[] zval = ((SM2PublicKey)sm2PublicKey).getDefaultZ();
                engine.update(zval, 0, zval.length);
            }
            byte[] buffer = new byte[65536];
            while ((rLength = in.read(buffer, 0, buffer.length)) != -1) {
                engine.update(buffer, 0, rLength);
            }
            engine.doFinal(hash, 0);
            byte[] byArray = hash;
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("hash file failure", e);
        }
        catch (Exception e) {
            throw new PKIException("hash file failure", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

