/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.cgb.toolkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.PrivateKey;
import msfpay.cfca.sadk.algorithm.common.CBCParam;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKCS7EnvelopedData;
import msfpay.cfca.sadk.algorithm.common.PKCS7SignedData;
import msfpay.cfca.sadk.algorithm.common.PKCS7SignedFile;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.util.FileUtil;
import msfpay.cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.algorithm.util.SM2AndItsCloseSymAlgUtil;
import msfpay.cfca.sadk.envelope.rsa.RSAEnvelopeUtil;
import msfpay.cfca.sadk.envelope.sm2.SM2EnvelopeUtil;
import msfpay.cfca.sadk.lib.crypto.JCrypto;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.lib.crypto.jni.JNISoftLib;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.system.CompatibleAlgorithm;
import msfpay.cfca.sadk.system.Mechanisms;
import msfpay.cfca.sadk.system.global.FileAndBufferConfig;
import msfpay.cfca.sadk.util.Base64;
import msfpay.cfca.sadk.util.CertUtil;
import msfpay.cfca.sadk.util.KeyUtil;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public final class Castle {
    private static final String encoding = "UTF-16LE";
    private SignerAlgorithmParameters rsaParams = null;
    private SignerAlgorithmParameters sm2Params = null;
    private Session session = null;

    public Castle() throws PKIException {
        this("JSOFT_LIB");
    }

    public Castle(String deviceName) throws PKIException {
        String cryptoName = "JSOFT_LIB";
        if ("JNISOFT_LIB".equals(deviceName)) {
            cryptoName = "JNISOFT_LIB";
        }
        JCrypto.getInstance().initialize(cryptoName, null);
        this.session = JCrypto.getInstance().openSession(cryptoName);
    }

    public static final void setCompatibleSM2WithoutZ(boolean compatibleSM2WithoutZ) {
        CompatibleAlgorithm.setCompatibleSM2WithoutZ(compatibleSM2WithoutZ);
    }

    public void initCertAppContext(String pfxFilePath, String pfxFilePassword, String sm2FilePath, String sm2FilePassword) throws PKIException {
        X509Cert cert;
        PrivateKey privateKey;
        if (pfxFilePath != null) {
            privateKey = KeyUtil.getPrivateKeyFromPFX(pfxFilePath, pfxFilePassword);
            cert = CertUtil.getCertFromPFX(pfxFilePath, pfxFilePassword);
            this.rsaParams = new SignerAlgorithmParameters(cert, privateKey);
        }
        if (sm2FilePath != null) {
            privateKey = KeyUtil.getPrivateKeyFromSM2(sm2FilePath, sm2FilePassword);
            cert = CertUtil.getCertFromSM2(sm2FilePath);
            this.sm2Params = new SignerAlgorithmParameters(cert, privateKey);
        }
    }

    public String signData(String srcMessage) throws PKIException {
        return this.signedMessage(true, Mechanisms.M_SHA1_RSA, srcMessage);
    }

    public String signData(String signAlg, String srcMessage) throws PKIException {
        return this.signedMessage(true, this.mechanismFrom(signAlg), srcMessage);
    }

    private Mechanism mechanismFrom(String signAlg) {
        return Mechanisms.signMechanismFrom(signAlg);
    }

    public String signDataDetached(String srcMessage) throws PKIException {
        return this.signedMessage(false, Mechanisms.M_SHA1_RSA, srcMessage);
    }

    public String signDataDetached(String signAlg, String srcMessage) throws PKIException {
        return this.signedMessage(false, this.mechanismFrom(signAlg), srcMessage);
    }

    private final String signedMessage(boolean attached, Mechanism mechanism, String srcMessage) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for signAlg");
        }
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        SignerAlgorithmParameters params = this.buildAndCheckSignerAlgorithmParameters(mechanism);
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        byte[] sourceData = null;
        byte[] signture = null;
        try {
            sourceData = srcMessage.getBytes(encoding);
            signture = this.session.sign(mechanism, params.privateKey, sourceData);
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedMessage", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedMessage", e);
        }
        if (!attached) {
            sourceData = null;
        }
        try {
            return new String(Base64.encode(p7.packageSignedData(attached, null, sourceData, signture, mechanism, params.certs)));
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
    }

    public String signFile(String srcFilePath) throws PKIException {
        return this.signedFile(true, Mechanisms.M_SHA1_RSA, srcFilePath);
    }

    public String signFile(String signAlg, String srcFilePath) throws PKIException {
        return this.signedFile(true, this.mechanismFrom(signAlg), srcFilePath);
    }

    public String signFileDetached(String srcFilePath) throws PKIException {
        return this.signedFile(false, Mechanisms.M_SHA1_RSA, srcFilePath);
    }

    public String signFileDetached(String signAlg, String srcFilePath) throws PKIException {
        return this.signedFile(false, this.mechanismFrom(signAlg), srcFilePath);
    }

    private final String signedFile(boolean attached, Mechanism mechanism, String srcFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for signAlg");
        }
        if (srcFilePath == null) {
            throw new IllegalArgumentException("null not allowed for srcFilePath");
        }
        SignerAlgorithmParameters params = this.buildAndCheckSignerAlgorithmParameters(mechanism);
        FileInputStream fis = null;
        byte[] signture = null;
        try {
            fis = new FileInputStream(srcFilePath);
            signture = this.session.sign(mechanism, params.privateKey, fis);
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedFile", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN_DES, "Failure on signedFile", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        if (attached) {
            PKCS7SignedFile p7 = new PKCS7SignedFile(this.session);
            String p7sFile = srcFilePath + ".p7s";
            try {
                p7.packageSignedFile(null, srcFilePath, p7sFile, signture, mechanism, params.certs);
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.SIGN, "Failure on packageSignedFile", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.SIGN, "Failure on packageSignedFile", e);
            }
            return p7sFile;
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        try {
            return new String(Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, params.certs)));
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SIGN, "Failure on packageSignedData", e);
        }
    }

    public byte[] getCertificate(String signedMessage) throws PKIException {
        if (signedMessage == null) {
            throw new IllegalArgumentException("null not allowed for signedMessage");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        p7.loadBase64(signedMessage.getBytes());
        X509Cert cert = p7.getSignerX509Cert();
        if (cert == null) {
            throw new SecurityException("signed certificate not found");
        }
        return cert.getEncoded();
    }

    public String verifySignedData(String signedMessage) throws PKIException {
        return this.verifySignedMessage(signedMessage, null);
    }

    public boolean verifyDetachedSignedData(String signedMessage, String srcMessage) throws PKIException {
        byte[] message;
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        try {
            message = srcMessage.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
        }
        return this.verifySignedMessage(signedMessage, message) != null;
    }

    public boolean verifyDetachedSignedDataAU(String signedMessage, String srcMessage) throws PKIException {
        byte[] message;
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        try {
            message = srcMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
        }
        return this.verifySignedMessage(signedMessage, message) != null;
    }

    private final String verifySignedMessage(String signedMessage, byte[] message) throws PKIException {
        if (signedMessage == null) {
            throw new IllegalArgumentException("null not allowed for signedMessage");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        byte[] signData = signedMessage.getBytes();
        try {
            p7.loadBase64(signData);
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        boolean verifyResult = false;
        if (message != null) {
            try {
                verifyResult = p7.verifyP7SignedData(message);
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
            }
            if (verifyResult) {
                return "Okay";
            }
        } else {
            try {
                verifyResult = p7.verifyP7SignedDataAttach();
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            if (verifyResult) {
                try {
                    return new String(p7.getSourceData(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on encoding sourceData", e);
                }
            }
        }
        return null;
    }

    public boolean verifySignedFile(String signedFilePath, String srcFilePath) throws PKIException {
        boolean verifyResult;
        if (signedFilePath == null) {
            throw new IllegalArgumentException("null not allowed for signedFilePath");
        }
        File file = new File(signedFilePath);
        if (!file.exists()) {
            throw new SecurityException("signedFilePath invalid");
        }
        if (file.length() <= (long)FileAndBufferConfig.SIGN_FILE_SIZE) {
            boolean verifyResult2;
            PKCS7SignedData p7 = new PKCS7SignedData(this.session);
            try {
                p7.loadBase64(FileUtil.getBytesFromFile(signedFilePath));
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
            }
            try {
                verifyResult2 = p7.verifyP7SignedDataAttach();
            }
            catch (PKIException e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedDataAttach", e);
            }
            if (verifyResult2 && srcFilePath != null && !"".equals(srcFilePath.trim())) {
                try {
                    FileUtil.writeBytesToFile(p7.getSourceData(), new FileOutputStream(srcFilePath));
                }
                catch (FileNotFoundException e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on write srcFilePath", e);
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.VERIFY_SIGN, "Failure on write srcFilePath", e);
                }
            }
            return verifyResult2;
        }
        PKCS7SignedFile p7 = new PKCS7SignedFile(this.session);
        try {
            verifyResult = p7.verifyP7SignedFile(signedFilePath, srcFilePath);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedFile", e);
        }
        return verifyResult;
    }

    public boolean verifyDetachedSignedFile(String signedResult, String srcFilePath) throws PKIException {
        if (signedResult == null) {
            throw new IllegalArgumentException("null not allowed for signedResult");
        }
        if (srcFilePath == null) {
            throw new IllegalArgumentException("null not allowed for srcFilePath");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        try {
            p7.loadBase64(signedResult.getBytes());
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, "Failure on loadSignedData", e);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(srcFilePath);
            boolean bl = p7.verifyP7SignedData(fis);
            return bl;
        }
        catch (PKIException e) {
            throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN_DES, "Failure on verifyP7SignedData", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String generateEnvelope(String srcMessage, String encryptAlg, byte[] certBytes) throws PKIException {
        if (srcMessage == null) {
            throw new IllegalArgumentException("null not allowed for srcMessage");
        }
        if (encryptAlg == null) {
            throw new IllegalArgumentException("null not allowed for encryptAlg");
        }
        if (certBytes == null) {
            throw new IllegalArgumentException("null not allowed for certBytes");
        }
        X509Cert encryptCert = null;
        X509Cert[] receiverCerts = null;
        boolean sm2Type = false;
        try {
            encryptCert = new X509Cert(certBytes);
            receiverCerts = new X509Cert[]{encryptCert};
            sm2Type = CertUtil.isSM2Cert(encryptCert);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, "invalid encrypt certificate", e);
        }
        if (sm2Type) {
            if (!"SM4/CBC/PKCS7Padding".equals(encryptAlg) && !"SM4/ECB/PKCS7Padding".equals(encryptAlg)) {
                throw new PKIException(PKIException.NOT_SUP_DES + ",SM2 cert:" + encryptAlg);
            }
        } else if (!("DESede/CBC/PKCS7Padding".equals(encryptAlg) || "DESede/ECB/PKCS7Padding".equals(encryptAlg) || "RC4".equals(encryptAlg))) {
            throw new PKIException(PKIException.NOT_SUP_DES + ",RSA cert:" + encryptAlg);
        }
        try {
            if (sm2Type) {
                return new String(SM2EnvelopeUtil.envelopeMessage(srcMessage.getBytes(encoding), encryptAlg, receiverCerts, this.session));
            }
            return new String(RSAEnvelopeUtil.envelopeMessage(srcMessage.getBytes(encoding), encryptAlg, receiverCerts, this.session));
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException(PKIException.ENCRYPT_DES, "failure on envelopeMessage", e);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT_DES, "failure on envelopeMessage", e);
        }
    }

    public String decodeEnvelope(String envelopedMessage) throws PKIException {
        CMSEnvelopedData cmsEnData;
        if (envelopedMessage == null) {
            throw new IllegalArgumentException("null not allowed for envelopedMessage");
        }
        try {
            cmsEnData = new CMSEnvelopedData(Base64.decode(envelopedMessage));
        }
        catch (CMSException e) {
            throw new PKIException(PKIException.DECRYPT, "load EnvelopedData failure", e);
        }
        try {
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            ASN1OctetString os = data.getEncryptedContent();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            Mechanism mechanism = this.buildMechanism(symmetricAlgId);
            boolean isSM2Type = mechanism.getMechanismType().indexOf("SM4") >= 0;
            byte[] symmetricKey = this.decodedSymmetricKey(isSM2Type, receivers);
            boolean jniFlag = this.session instanceof JNISoftLib;
            byte[] encryptedData = os.getOctets();
            byte[] decryptedData = null;
            decryptedData = isSM2Type ? SM2AndItsCloseSymAlgUtil.crypto(jniFlag, false, symmetricKey, encryptedData, mechanism) : RSAAndItsCloseSymAlgUtil.crypto(jniFlag, false, symmetricKey, encryptedData, mechanism);
            return new String(decryptedData, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    private final byte[] decodedSymmetricKey(boolean isSM2Type, ASN1Set receivers) throws PKIException {
        SignerAlgorithmParameters params;
        SignerAlgorithmParameters signerAlgorithmParameters = params = isSM2Type ? this.sm2Params : this.rsaParams;
        if (params == null) {
            throw new PKIException("recipient' certificate/privatekey not  initial");
        }
        X500Name recipientIssuer = params.cert.getIssuerX500Name();
        BigInteger recipientSN = params.cert.getSerialNumber();
        byte[] subjectPubKeyID = params.cert.getSubjectKeyIdentifier().getKeyIdentifier();
        if (receivers == null) {
            throw new PKIException("the receiver is null!!!");
        }
        ASN1OctetString encryptKey = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            KeyTransRecipientInfo inf;
            RecipientInfo recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !Castle.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), subjectPubKeyID, recipientIssuer, recipientSN)) continue;
            encryptKey = inf.getEncryptedKey();
            break;
        }
        if (encryptKey == null) {
            throw new PKIException("can not find the receiver!!!");
        }
        Mechanism contentEncryptionAlg = isSM2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
        return this.session.decrypt(contentEncryptionAlg, params.privateKey, encryptKey.getOctets());
    }

    private static boolean hasRecipent(KeyTransRecipientInfo inf, byte[] subjectPubKeyID, X500Name recipientIssuer, BigInteger recipientSN) {
        RecipientIdentifier id = inf.getRecipientIdentifier();
        DEROctetString oct = new DEROctetString(subjectPubKeyID);
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        return id.getId().toASN1Primitive().asn1Equals(oct) || id.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive());
    }

    private final Mechanism buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        if (symmetricAlgId == null || symmetricAlgId.getAlgorithm() == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "invalid AlgorithmIdentifier");
        }
        String encryptionAlgorithm = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
        if (encryptionAlgorithm == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "invalid AlgorithmIdentifier: " + symmetricAlgId.getAlgorithm());
        }
        Mechanism mechanism = null;
        if (encryptionAlgorithm.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            if (doct == null || doct.getOctets() == null) {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "missing cbc-param");
            }
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            if (encryptionAlgorithm.equals("DESede/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
            } else if (encryptionAlgorithm.equals("SM4/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
            }
        } else if (encryptionAlgorithm.indexOf("ECB") != -1) {
            if (encryptionAlgorithm.equals("DESede/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
            } else if (encryptionAlgorithm.equals("SM4/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
            }
        } else if (encryptionAlgorithm.indexOf("RC4") != -1) {
            mechanism = new Mechanism("RC4");
        }
        if (mechanism == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR_DES + "Algorithm is:" + encryptionAlgorithm);
        }
        return mechanism;
    }

    private final SignerAlgorithmParameters buildAndCheckSignerAlgorithmParameters(Mechanism signAlg) throws PKIException {
        if (!Mechanism.isValid(signAlg)) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
        }
        SignerAlgorithmParameters params = null;
        if (Mechanisms.isSM2WithSM3(signAlg)) {
            if (this.sm2Params == null) {
                throw new PKIException(PKIException.SIGN, "null not allowed for sm2Cert/sm2PriKey when signAlg as " + signAlg);
            }
            params = this.sm2Params;
        } else {
            if (this.rsaParams == null) {
                throw new PKIException(PKIException.SIGN, "null not allowed for rsaCert/rsaPriKey when signAlg as " + signAlg);
            }
            params = this.rsaParams;
        }
        return params;
    }

    static final class SignerAlgorithmParameters {
        final PrivateKey privateKey;
        final X509Cert[] certs;
        final X509Cert cert;

        SignerAlgorithmParameters(X509Cert cert, PrivateKey privateKey) {
            this.cert = cert;
            this.certs = new X509Cert[]{cert};
            this.privateKey = privateKey;
        }
    }
}

