/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.asn1.ocsp;

import java.io.IOException;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponse;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.ResponseBytes;
import msfpay.cfca.sadk.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import msfpay.cfca.sadk.org.bouncycastle.cert.ocsp.OCSPResp;

public class OCSPRespGenerator {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;

    public OCSPResp generate(int status, Object response) throws PKIException, IOException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        BasicOCSPResp r = (BasicOCSPResp)response;
        DEROctetString octs = new DEROctetString(r.getEncoded());
        ResponseBytes rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, octs);
        return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), rb));
    }
}

