/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.asn1.ocsp;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERBitString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.OCSPRequest;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.Request;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.Signature;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ocsp.TBSRequest;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import msfpay.cfca.sadk.org.bouncycastle.cert.ocsp.CertificateID;
import msfpay.cfca.sadk.org.bouncycastle.cert.ocsp.OCSPReq;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public class OCSPReqGenerator {
    private ArrayList list = new ArrayList();
    private GeneralName requestorName = null;
    private Extensions requestExtensions = null;
    public static final int URI_TYPE_NAME = 6;
    public static final int DN_TYPE_NAME = 4;

    private ASN1Object makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    public void addRequest(CertificateID certId) {
        this.list.add(new RequestObject(certId, null));
    }

    public void addRequest(CertificateID certId, Extensions singleRequestExtensions) {
        this.list.add(new RequestObject(certId, singleRequestExtensions));
    }

    public void setRequestorName(String name, int nameType) {
        if (nameType == 4) {
            X500Name x509DPName = new X500Name(name);
            this.requestorName = new GeneralName(x509DPName);
        } else if (nameType == 6) {
            byte[] bName = name.getBytes();
            DERIA5String ia5Name = DERIA5String.getInstance(bName);
            this.requestorName = new GeneralName(6, ia5Name);
        }
    }

    public void setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
    }

    public void setRequestExtensions(Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
    }

    public OCSPReq generateRequest() throws PKIException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new PKIException("850800", "\u6784\u9020\u8bf7\u6c42\u5217\u8868\u5931\u8d25", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        return new OCSPReq(new OCSPRequest(tbsReq, null));
    }

    public OCSPReq generateRequest(String signingAlgorithm, PrivateKey priKey, Session session) throws PKIException {
        return this.generateRequest(signingAlgorithm, priKey, null, session);
    }

    public OCSPReq generateRequest(String signingAlgorithm, PrivateKey priKey, X509Cert[] chain, Session session) throws PKIException {
        ASN1ObjectIdentifier sigAlgOID = Mechanism.getObjectIdentifier(signingAlgorithm);
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new PKIException("850800", "\u6784\u9020\u8bf7\u6c42\u5217\u8868\u5931\u8d25", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        if (!(signingAlgorithm.equalsIgnoreCase("MD2withRSAEncryption") || signingAlgorithm.equalsIgnoreCase("MD5withRSAEncryption") || signingAlgorithm.equalsIgnoreCase("SHA1withRSAEncryption") || signingAlgorithm.equalsIgnoreCase("SHA256withRSAEncryption"))) {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        byte[] sigValue = null;
        try {
            sigValue = session.sign(new Mechanism(signingAlgorithm), priKey, tbsReq.getEncoded());
        }
        catch (IOException ex) {
            throw new PKIException("850812", "OCSP TBSReq\u7f16\u7801\u5931\u8d25", ex);
        }
        catch (PKIException ex) {
            throw new PKIException("05", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        DERBitString bitSig = new DERBitString(sigValue);
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(sigAlgOID, DERNull.INSTANCE);
        Signature signature = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i != chain.length; ++i) {
                v.add(chain[i].getCertStructure());
            }
            signature = new Signature(sigAlgId, bitSig, new DERSequence(v));
        } else {
            signature = new Signature(sigAlgId, bitSig);
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    private class RequestObject {
        CertificateID certId;
        Extensions extensions;

        public RequestObject(CertificateID certId, Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() throws Exception {
            return new Request(this.certId.toASN1Object(), this.extensions);
        }
    }
}

