/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.algorithm.util;

import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import msfpay.cfca.sadk.system.Mechanisms;

public class HashEncoderUtil {
    public static byte[] derEncoder(String signAlg, byte[] hash) throws PKIException {
        try {
            if ("SM3".equals(signAlg) || "SM-3".equals(signAlg) || Mechanisms.isSM2WithSM3(signAlg)) {
                return hash;
            }
            AlgorithmIdentifier digestAlgIdentifier = Mechanisms.getDigestAlgIdentifier(signAlg);
            if (digestAlgIdentifier == null) {
                throw new PKIException(PKIException.DIGEST, PKIException.DIGEST_DES + " " + PKIException.NOT_SUP_DES + " " + signAlg);
            }
            DigestInfo dInfo = new DigestInfo(digestAlgIdentifier, hash);
            return dInfo.getEncoded("DER");
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("hash encoded failure", e);
        }
    }

    public static byte[] derEncoder(Mechanism mechanism, byte[] digest) throws PKIException {
        return HashEncoderUtil.derEncoder(mechanism.getMechanismType(), digest);
    }
}

