/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.algorithm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import msfpay.cfca.sadk.algorithm.common.CBCParam;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.sm2.SM4Engine;
import msfpay.cfca.sadk.asn1.parser.ASN1Node;
import msfpay.cfca.sadk.lib.crypto.jni.JNISymAlg;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import msfpay.cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import msfpay.cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import msfpay.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import msfpay.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import msfpay.cfca.sadk.system.global.FileAndBufferConfig;

public class BigFileCipherUtil {
    public static void bigFileBlockCipher(boolean encryptFlag, Mechanism alg, byte[] key, InputStream inputStream, OutputStream outputStream) throws Exception {
        try {
            KeyParameter params;
            ParametersWithIV params2;
            Object param;
            String type = alg.getMechanismType();
            PaddedBufferedBlockCipher cipher = null;
            RC4Engine rc4 = null;
            if (type.equals("RC4")) {
                rc4 = new RC4Engine();
                param = new KeyParameter(key);
                rc4.init(encryptFlag, (CipherParameters)param);
            } else if (type.equals("DESede/CBC/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()), new PKCS7Padding());
                param = (CBCParam)alg.getParam();
                params2 = new ParametersWithIV(new KeyParameter(key), ((CBCParam)param).getIv());
                cipher.init(encryptFlag, params2);
            } else if (type.equals("SM4/CBC/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
                param = (CBCParam)alg.getParam();
                params2 = new ParametersWithIV(new KeyParameter(key), ((CBCParam)param).getIv());
                cipher.init(encryptFlag, params2);
            } else if (type.equals("DESede/ECB/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new DESedeEngine(), new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(encryptFlag, params);
            } else if (type.equals("SM4/ECB/PKCS7Padding")) {
                cipher = new PaddedBufferedBlockCipher(new SM4Engine(), new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(encryptFlag, params);
            } else {
                throw new PKIException("do not support this algorithm:" + type);
            }
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            if (rc4 != null) {
                byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                while ((readLen = inputStream.read(buffer)) > 0) {
                    rc4.processBytes(buffer, 0, readLen, outBytes, 0);
                    outputStream.write(outBytes, 0, readLen);
                }
            } else {
                byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
                int processLen = 0;
                boolean isFinal = false;
                while ((readLen = inputStream.read(buffer)) > 0) {
                    if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER) {
                        processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                        outputStream.write(outBytes, 0, processLen);
                        continue;
                    }
                    int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    int len2 = cipher.doFinal(outBytes, len1);
                    outputStream.write(outBytes, 0, len1 + len2);
                    isFinal = true;
                    break;
                }
                if (!isFinal) {
                    int len = cipher.doFinal(outBytes, 0);
                    outputStream.write(outBytes, 0, len);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void bigFileDecrypt_JNI(int nid_type, byte[] key, CBCParam param, ASN1Node file_encrypted, OutputStream fos) throws Exception {
        block12: {
            RandomAccessFile raf = null;
            try {
                JNISymAlg jni = new JNISymAlg();
                if (param == null) {
                    jni.decryptInit(nid_type, key, null);
                } else {
                    jni.decryptInit(nid_type, key, param.getIv());
                }
                File encrypted_f = file_encrypted.f;
                long valueStartPos = file_encrypted.valueStartPos;
                long totalLength = file_encrypted.valueLength;
                long readTotalLen = 0L;
                int readLen = 0;
                int processLen = 0;
                byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
                raf = new RandomAccessFile(encrypted_f, "r");
                raf.seek(valueStartPos);
                if (totalLength > (long)FileAndBufferConfig.BIG_FILE_BUFFER) {
                    while ((readLen = raf.read(temp)) > 0) {
                        if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < totalLength) {
                            processLen = jni.decryptProcess(temp, 0, readLen, outBytes, 0);
                            fos.write(outBytes, 0, processLen);
                            continue;
                        }
                        int len1 = jni.decryptProcess(temp, 0, readLen, outBytes, 0);
                        int len2 = jni.decryptFinal(outBytes, len1);
                        fos.write(outBytes, 0, len1 + len2);
                        break block12;
                    }
                    break block12;
                }
                readLen = raf.read(temp, 0, (int)totalLength);
                int len1 = jni.decryptProcess(temp, 0, readLen, outBytes, 0);
                int len2 = jni.decryptFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static void bigFileDecrypt_JNI(int nid_type, byte[] key, CBCParam param, ASN1Node file_encrypted, OutputStream fos, RandomAccessFile raf) throws Exception {
        try {
            JNISymAlg jni = new JNISymAlg();
            if (param == null) {
                jni.decryptInit(nid_type, key, null);
            } else {
                jni.decryptInit(nid_type, key, param.getIv());
            }
            byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long valueStartPos = 0L;
            int valueLen = 0;
            int childLen = file_encrypted.childNodes.size();
            int readTotalLen = 0;
            int len1 = 0;
            for (int i = 0; i < childLen; ++i) {
                ASN1Node file_encrypted_child = (ASN1Node)file_encrypted.childNodes.get(i);
                valueStartPos = file_encrypted_child.valueStartPos;
                valueLen = (int)file_encrypted_child.valueLength;
                raf.seek(valueStartPos);
                int currentLen = raf.read(temp, readTotalLen, valueLen);
                if ((readTotalLen += currentLen) < FileAndBufferConfig.BIG_FILE_BUFFER) continue;
                len1 = jni.decryptProcess(temp, 0, readTotalLen, outBytes, 0);
                fos.write(outBytes, 0, len1);
                readTotalLen = 0;
            }
            if (readTotalLen > 0) {
                len1 = jni.decryptProcess(temp, 0, readTotalLen, outBytes, 0);
            }
            int len2 = jni.encryptFinal(outBytes, len1);
            fos.write(outBytes, 0, len1 + len2);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void bigFileBlockDecrypt(byte[] key, BlockCipher engine, CBCParam param, ASN1Node file_encrypted, OutputStream fos) throws Exception {
        block12: {
            RandomAccessFile raf = null;
            try {
                CipherParameters params;
                PaddedBufferedBlockCipher cipher = null;
                if (param == null) {
                    cipher = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
                    params = new KeyParameter(key);
                    cipher.init(false, params);
                } else {
                    cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
                    params = new ParametersWithIV(new KeyParameter(key), param.getIv());
                    cipher.init(false, params);
                }
                File encrypted_f = file_encrypted.f;
                long valueStartPos = file_encrypted.valueStartPos;
                long totalLength = file_encrypted.valueLength;
                long readTotalLen = 0L;
                int readLen = 0;
                int processLen = 0;
                byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
                raf = new RandomAccessFile(encrypted_f, "r");
                raf.seek(valueStartPos);
                if (totalLength > (long)FileAndBufferConfig.BIG_FILE_BUFFER) {
                    while ((readLen = raf.read(temp)) > 0) {
                        if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < totalLength) {
                            processLen = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                            fos.write(outBytes, 0, processLen);
                            continue;
                        }
                        int len1 = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                        int len2 = cipher.doFinal(outBytes, len1);
                        fos.write(outBytes, 0, len1 + len2);
                        break block12;
                    }
                    break block12;
                }
                readLen = raf.read(temp, 0, (int)totalLength);
                int len1 = cipher.processBytes(temp, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static void bigFileBlockDecrypt(PaddedBufferedBlockCipher cipher, ASN1Node file_encrypted, OutputStream fos, RandomAccessFile raf) throws Exception {
        byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
        long valueStartPos = 0L;
        int valueLen = 0;
        int childLen = file_encrypted.childNodes.size();
        int readTotalLen = 0;
        int len1 = 0;
        for (int i = 0; i < childLen; ++i) {
            ASN1Node file_encrypted_child = (ASN1Node)file_encrypted.childNodes.get(i);
            valueStartPos = file_encrypted_child.valueStartPos;
            valueLen = (int)file_encrypted_child.valueLength;
            raf.seek(valueStartPos);
            int currentLen = raf.read(temp, readTotalLen, valueLen);
            if ((readTotalLen += currentLen) < FileAndBufferConfig.BIG_FILE_BUFFER) continue;
            len1 = cipher.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, len1);
            readTotalLen = 0;
        }
        if (readTotalLen > 0) {
            len1 = cipher.processBytes(temp, 0, readTotalLen, outBytes, 0);
        }
        int len2 = cipher.doFinal(outBytes, len1);
        fos.write(outBytes, 0, len1 + len2);
    }

    public static void bigFileRC4Decrypt(StreamCipher cipher, byte[] key, ASN1Node file_encrypted, OutputStream fos) throws Exception {
        block9: {
            RandomAccessFile raf = null;
            try {
                KeyParameter param = new KeyParameter(key);
                cipher.init(false, param);
                File encrypted_f = file_encrypted.f;
                long valueStartPos = file_encrypted.valueStartPos;
                long totalLength = file_encrypted.valueLength;
                long readTotalLen = 0L;
                int readLen = 0;
                byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
                raf = new RandomAccessFile(encrypted_f, "r");
                raf.seek(valueStartPos);
                if (totalLength > (long)FileAndBufferConfig.BIG_FILE_BUFFER) {
                    while ((readLen = raf.read(temp)) > 0) {
                        if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && readTotalLen < totalLength) {
                            readTotalLen += (long)readLen;
                            cipher.processBytes(temp, 0, readLen, outBytes, 0);
                            fos.write(outBytes);
                            continue;
                        }
                        cipher.processBytes(temp, 0, readLen, outBytes, 0);
                        fos.write(outBytes, 0, readLen);
                        break block9;
                    }
                    break block9;
                }
                readLen = raf.read(temp, 0, (int)totalLength);
                cipher.processBytes(temp, 0, readLen, outBytes, 0);
                fos.write(outBytes, 0, readLen);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
    }

    public static void bigFileRC4Decrypt(StreamCipher rc4, ASN1Node file_encrypted, OutputStream fos, RandomAccessFile raf) throws Exception {
        long valueStartPos = 0L;
        int readTotalLen = 0;
        byte[] temp = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        int childLen = file_encrypted.childNodes.size();
        int valueLen = 0;
        for (int i = 0; i < childLen; ++i) {
            ASN1Node file_encrypted_child = (ASN1Node)file_encrypted.childNodes.get(i);
            valueStartPos = file_encrypted_child.valueStartPos;
            valueLen = (int)file_encrypted_child.valueLength;
            raf.seek(valueStartPos);
            int currentReadLen = raf.read(temp, readTotalLen, valueLen);
            if ((readTotalLen += currentReadLen) < FileAndBufferConfig.BIG_FILE_BUFFER) continue;
            rc4.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, readTotalLen);
            readTotalLen = 0;
        }
        if (readTotalLen > 0) {
            rc4.processBytes(temp, 0, readTotalLen, outBytes, 0);
            fos.write(outBytes, 0, readTotalLen);
        }
    }

    public static void bigFileBlockEncrypt(byte[] key, BlockCipher engine, CBCParam param, File f, ASN1OutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            CipherParameters params;
            PaddedBufferedBlockCipher cipher = null;
            if (param == null) {
                cipher = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(true, params);
            } else {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
                params = new ParametersWithIV(new KeyParameter(key), param.getIv());
                cipher.init(true, params);
            }
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = f.length();
            int processLen = 0;
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    out.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                out.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static void bigFileRC4Encrypt(byte[] key, StreamCipher rc4, File f, ASN1OutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            KeyParameter param = new KeyParameter(key);
            rc4.init(true, param);
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                rc4.processBytes(buffer, 0, readLen, outBytes, 0);
                out.write(outBytes, 0, readLen);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bigFileEncrypt_JNI(int nid_type, byte[] key, byte[] iv, File f, ASN1OutputStream out) throws Exception {
        JNISymAlg jni = new JNISymAlg();
        jni.encryptInit(nid_type, key, iv);
        int readLen = 0;
        byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
        long readTotalLen = 0L;
        long fileLen = f.length();
        int processLen = 0;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            while ((readLen = ((InputStream)fis).read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = jni.encryptProcess(buffer, 0, readLen, outBytes, 0);
                    out.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = jni.encryptProcess(buffer, 0, readLen, outBytes, 0);
                int len2 = jni.encryptFinal(outBytes, len1);
                out.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        finally {
            if (fis != null) {
                ((InputStream)fis).close();
            }
        }
    }
}

