/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.algorithm.util;

public class BigEndianUtil {
    public static byte[] bigEndianIntToByte(int num) {
        return BigEndianUtil.back(BigEndianUtil.IntToByte(num));
    }

    public static int bigEndianByteToInt(byte[] bytes) {
        return BigEndianUtil.ByteToInt(BigEndianUtil.back(bytes));
    }

    public static byte[] bigEndianLongTobyte(long n) {
        return BigEndianUtil.back(BigEndianUtil.LongToByte(n));
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    public static byte[] LongToByte(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] IntToByte(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int ByteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }
}

