/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.algorithm.sm2;

import java.math.BigInteger;
import msfpay.cfca.sadk.algorithm.sm2.SM2PublicKey;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import msfpay.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import msfpay.cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import msfpay.cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import msfpay.cfca.sadk.org.bouncycastle.util.BigIntegers;

public final class SM2PrivateKey
implements msfpay.cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey {
    private static final long serialVersionUID = -3613783346296166756L;
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private final BigInteger dInt;
    private final byte[] dBytes;
    private final byte[] zvalue;
    private SM2PublicKey pubKey = null;

    public static SM2PrivateKey getInstance(byte[] encoded) {
        return new SM2PrivateKey(encoded);
    }

    public SM2PrivateKey(byte[] encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        switch (encoded.length) {
            case 32: {
                this.dInt = this.dIntegerFrom(encoded);
                break;
            }
            case 96: {
                this.dInt = this.dIntegerFrom(encoded);
                byte[] bPubX = new byte[32];
                byte[] bPubY = new byte[32];
                System.arraycopy(encoded, 32, bPubX, 0, 32);
                System.arraycopy(encoded, 64, bPubY, 0, 32);
                this.pubKey = new SM2PublicKey(bPubX, bPubY);
                break;
            }
            default: {
                try {
                    AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(DERNull.INSTANCE));
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(encoded);
                    if (!aid.equals(info.getPrivateKeyAlgorithm())) {
                        throw new SecurityException("encoded not valid");
                    }
                    ECPrivateKey key = ECPrivateKey.getInstance(info.parsePrivateKey());
                    this.dInt = key.getKey();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("encoded not valid", e);
                }
            }
        }
        if (this.pubKey == null) {
            this.pubKey = SM2PrivateKey.buildPublicKey(this.dInt);
        }
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public SM2PrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        if (dBytes == null) {
            throw new IllegalArgumentException("null not allowed for dBytes");
        }
        this.dInt = new BigInteger(1, dBytes);
        this.dBytes = dBytes;
        this.pubKey = bPubX != null && bPubY != null ? new SM2PublicKey(bPubX, bPubY) : SM2PrivateKey.buildPublicKey(this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public SM2PrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d");
        }
        this.dInt = d;
        this.dBytes = BigIntegers.asUnsignedByteArray(32, d);
        this.pubKey = iPubX != null && iPubY != null ? new SM2PublicKey(iPubX, iPubY) : SM2PrivateKey.buildPublicKey(d);
        this.zvalue = this.pubKey.getZvalue();
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        this(ecPrivateKeyParameters, null);
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        if (ecPrivateKeyParameters == null) {
            throw new IllegalArgumentException("null not allowed for ecPrivateKeyParameters");
        }
        if (!SM2Params.sm2DomainParameters.equals(ecPrivateKeyParameters.getParameters())) {
            throw new IllegalArgumentException("domainParameters not allowed for ecPrivateKeyParameters");
        }
        this.dInt = ecPrivateKeyParameters.getD();
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.dInt);
        if (ecPublicKeyParameters == null) {
            this.pubKey = SM2PrivateKey.buildPublicKey(this.dInt);
        } else {
            if (!SM2Params.sm2DomainParameters.equals(ecPublicKeyParameters.getParameters())) {
                throw new IllegalArgumentException("domainParameters not allowed for ecPublicKeyParameters");
            }
            this.pubKey = new SM2PublicKey(ecPublicKeyParameters);
        }
        this.zvalue = this.pubKey.getZvalue();
    }

    private final BigInteger dIntegerFrom(byte[] encoded) {
        byte[] value = new byte[32];
        System.arraycopy(encoded, 0, value, 0, 32);
        return new BigInteger(1, value);
    }

    public byte[] getEncoded() {
        try {
            X962Parameters params = new X962Parameters(DERNull.INSTANCE);
            ECPrivateKey keyStructure = new ECPrivateKey(this.getDByInt(), params);
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoded Failure for SM2PrivateKey", e);
        }
    }

    public void setSM2PublicKey(SM2PublicKey pubKey) {
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.pubKey;
    }

    public BigInteger getD() {
        return this.dInt;
    }

    public BigInteger getDByInt() {
        return this.dInt;
    }

    public byte[] getD_Bytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytesWithPublicKey() {
        byte[] encoded = null;
        if (this.pubKey != null) {
            encoded = new byte[96];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
            System.arraycopy(this.pubKey.getPubXByBytes(), 0, encoded, 32, 32);
            System.arraycopy(this.pubKey.getPubYByBytes(), 0, encoded, 64, 32);
        } else {
            encoded = new byte[32];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
        }
        return encoded;
    }

    public byte[] getZvalue() {
        return (byte[])this.zvalue.clone();
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    private static SM2PublicKey buildPublicKey(BigInteger d) {
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new SM2PublicKey(new ECPublicKeyParameters(Q, params));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dInt == null ? 0 : this.dInt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SM2PrivateKey other = (SM2PrivateKey)obj;
        return !(this.dInt == null ? other.dInt != null : !this.dInt.equals(other.dInt));
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2 Private Key: ");
        buffer.append(separator);
        buffer.append("D:");
        if (this.dInt != null) {
            buffer.append(this.dInt.toString(16));
        }
        return buffer.toString();
    }

    public final BigInteger dBigInteger() {
        return this.dInt;
    }
}

