/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.storage.StorageAccountCheckNameAvailabilityParameters;
import com.microsoft.azure.management.storage.StorageAccountRegenerateKeyParameters;
import com.microsoft.azure.management.storage.implementation.AccountSasParametersInner;
import com.microsoft.azure.management.storage.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.storage.implementation.ListAccountSasResponseInner;
import com.microsoft.azure.management.storage.implementation.ListServiceSasResponseInner;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.ServiceSasParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountCreateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountListKeysResultInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountUpdateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class StorageAccountsInner
implements InnerSupportsGet<StorageAccountInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<StorageAccountInner> {
    private StorageAccountsService service;
    private StorageManagementClientImpl client;

    public StorageAccountsInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (StorageAccountsService)retrofit.create(StorageAccountsService.class);
        this.client = client;
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        StorageAccountCheckNameAvailabilityParameters accountName = new StorageAccountCheckNameAvailabilityParameters();
        accountName.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), accountName, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner create(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<StorageAccountInner> createAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> createAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<StorageAccountInner>(){}.getType());
    }

    public StorageAccountInner beginCreate(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> beginCreateAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> beginCreateAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner update(String resourceGroupName, String accountName, StorageAccountUpdateParametersInner parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> updateAsync(String resourceGroupName, String accountName, StorageAccountUpdateParametersInner parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> updateAsync(String resourceGroupName, String accountName, StorageAccountUpdateParametersInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountUpdateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<StorageAccountInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<StorageAccountInner>(page){

            public Page<StorageAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<StorageAccountInner>> listAsync(ServiceCallback<List<StorageAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<StorageAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<StorageAccountInner>>, Page<StorageAccountInner>>(){

            public Page<StorageAccountInner> call(ServiceResponse<List<StorageAccountInner>> response) {
                PageImpl<StorageAccountInner> page = new PageImpl<StorageAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<StorageAccountInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<List<StorageAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<StorageAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<StorageAccountInner>(page){

            public Page<StorageAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<StorageAccountInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<StorageAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<StorageAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<StorageAccountInner>>, Page<StorageAccountInner>>(){

            public Page<StorageAccountInner> call(ServiceResponse<List<StorageAccountInner>> response) {
                PageImpl<StorageAccountInner> page = new PageImpl<StorageAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<StorageAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<List<StorageAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return (StorageAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<StorageAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<StorageAccountListKeysResultInner>, StorageAccountListKeysResultInner>(){

            public StorageAccountListKeysResultInner call(ServiceResponse<StorageAccountListKeysResultInner> response) {
                return (StorageAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<StorageAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountListKeysResultInner regenerateKey(String resourceGroupName, String accountName, String keyName) {
        return (StorageAccountListKeysResultInner)((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).toBlocking().single()).body();
    }

    public ServiceFuture<StorageAccountListKeysResultInner> regenerateKeyAsync(String resourceGroupName, String accountName, String keyName, ServiceCallback<StorageAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName), serviceCallback);
    }

    public Observable<StorageAccountListKeysResultInner> regenerateKeyAsync(String resourceGroupName, String accountName, String keyName) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).map((Func1)new Func1<ServiceResponse<StorageAccountListKeysResultInner>, StorageAccountListKeysResultInner>(){

            public StorageAccountListKeysResultInner call(ServiceResponse<StorageAccountListKeysResultInner> response) {
                return (StorageAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountListKeysResultInner>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        StorageAccountRegenerateKeyParameters regenerateKey = new StorageAccountRegenerateKeyParameters();
        regenerateKey.withKeyName(keyName);
        return this.service.regenerateKey(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), regenerateKey, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<StorageAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.regenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountListKeysResultInner> regenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ListAccountSasResponseInner listAccountSAS(String resourceGroupName, String accountName, AccountSasParametersInner parameters) {
        return (ListAccountSasResponseInner)((ServiceResponse)this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ListAccountSasResponseInner> listAccountSASAsync(String resourceGroupName, String accountName, AccountSasParametersInner parameters, ServiceCallback<ListAccountSasResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<ListAccountSasResponseInner> listAccountSASAsync(String resourceGroupName, String accountName, AccountSasParametersInner parameters) {
        return this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<ListAccountSasResponseInner>, ListAccountSasResponseInner>(){

            public ListAccountSasResponseInner call(ServiceResponse<ListAccountSasResponseInner> response) {
                return (ListAccountSasResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListAccountSasResponseInner>> listAccountSASWithServiceResponseAsync(String resourceGroupName, String accountName, AccountSasParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.listAccountSAS(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListAccountSasResponseInner>>>(){

            public Observable<ServiceResponse<ListAccountSasResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listAccountSASDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListAccountSasResponseInner> listAccountSASDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListAccountSasResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ListServiceSasResponseInner listServiceSAS(String resourceGroupName, String accountName, ServiceSasParametersInner parameters) {
        return (ListServiceSasResponseInner)((ServiceResponse)this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ListServiceSasResponseInner> listServiceSASAsync(String resourceGroupName, String accountName, ServiceSasParametersInner parameters, ServiceCallback<ListServiceSasResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<ListServiceSasResponseInner> listServiceSASAsync(String resourceGroupName, String accountName, ServiceSasParametersInner parameters) {
        return this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<ListServiceSasResponseInner>, ListServiceSasResponseInner>(){

            public ListServiceSasResponseInner call(ServiceResponse<ListServiceSasResponseInner> response) {
                return (ListServiceSasResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListServiceSasResponseInner>> listServiceSASWithServiceResponseAsync(String resourceGroupName, String accountName, ServiceSasParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.listServiceSAS(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListServiceSasResponseInner>>>(){

            public Observable<ServiceResponse<ListServiceSasResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listServiceSASDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListServiceSasResponseInner> listServiceSASDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListServiceSasResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface StorageAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body StorageAccountCheckNameAvailabilityParameters var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountUpdateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/storageAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body StorageAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listAccountSAS"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListAccountSas")
        public Observable<Response<ResponseBody>> listAccountSAS(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body AccountSasParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listServiceSAS"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListServiceSas")
        public Observable<Response<ResponseBody>> listServiceSAS(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body ServiceSasParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

