/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.locks.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.locks.LockLevel;
import com.microsoft.azure.management.locks.ManagementLock;
import com.microsoft.azure.management.locks.implementation.AuthorizationManager;
import com.microsoft.azure.management.locks.implementation.ManagementLockClientImpl;
import com.microsoft.azure.management.locks.implementation.ManagementLockObjectInner;
import com.microsoft.azure.management.locks.implementation.ManagementLocksImpl;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import rx.Observable;

@LangDefinition
class ManagementLockImpl
extends CreatableUpdatableImpl<ManagementLock, ManagementLockObjectInner, ManagementLockImpl>
implements ManagementLock,
ManagementLock.Definition,
ManagementLock.Update {
    private final AuthorizationManager manager;
    private String lockedResourceId = null;

    ManagementLockImpl(String name, ManagementLockObjectInner innerModel, AuthorizationManager lockManager) {
        super(name, (Object)innerModel);
        this.manager = lockManager;
    }

    protected Observable<ManagementLockObjectInner> getInnerAsync() {
        return ((ManagementLockClientImpl)((Object)this.manager().inner())).managementLocks().getByScopeAsync(this.lockedResourceId, this.name());
    }

    @Override
    public ManagementLockImpl withNotes(String notes) {
        ((ManagementLockObjectInner)this.inner()).withNotes(notes);
        return this;
    }

    @Override
    public ManagementLockImpl withLevel(LockLevel level) {
        ((ManagementLockObjectInner)this.inner()).withLevel(level);
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResource(String resourceId) {
        this.lockedResourceId = resourceId;
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResource(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Missing resource ID.");
        }
        this.lockedResourceId = resource.id();
        return this;
    }

    @Override
    public ManagementLockImpl withLockedResourceGroup(String resourceGroupName) {
        return this.withLockedResource(this.manager().subscriptionId() + "/resourceGroups/" + resourceGroupName);
    }

    @Override
    public ManagementLockImpl withLockedResourceGroup(ResourceGroup resourceGroup) {
        if (resourceGroup == null) {
            throw new IllegalArgumentException("Missing resource group ID.");
        }
        this.lockedResourceId = resourceGroup.id();
        return this;
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public Observable<ManagementLock> createResourceAsync() {
        return ((ManagementLockClientImpl)((Object)this.manager().inner())).managementLocks().createOrUpdateByScopeAsync(this.lockedResourceId, this.name(), (ManagementLockObjectInner)this.inner()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public boolean isInCreateMode() {
        return ((ManagementLockObjectInner)this.inner()).id() == null;
    }

    @Override
    public LockLevel level() {
        return ((ManagementLockObjectInner)this.inner()).level();
    }

    @Override
    public String lockedResourceId() {
        return ManagementLocksImpl.resourceIdFromLockId(((ManagementLockObjectInner)this.inner()).id());
    }

    @Override
    public String notes() {
        return ((ManagementLockObjectInner)this.inner()).notes();
    }

    public String id() {
        return ((ManagementLockObjectInner)this.inner()).id();
    }
}

