/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.ContainerServiceStorageProfileTypes;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.KubernetesCluster;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.ManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.OSType;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterImpl;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
public class KubernetesClusterAgentPoolImpl
extends ChildResourceImpl<ManagedClusterAgentPoolProfile, KubernetesClusterImpl, OrchestratorServiceBase>
implements KubernetesClusterAgentPool,
KubernetesClusterAgentPool.Definition {
    private String subnetName;

    KubernetesClusterAgentPoolImpl(ManagedClusterAgentPoolProfile inner, KubernetesClusterImpl parent) {
        super((Object)inner, (Object)parent);
        String subnetId = inner != null ? ((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        this.subnetName = ResourceUtils.nameFromResourceId((String)subnetId);
    }

    public String name() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).name();
    }

    @Override
    public int count() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).count();
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).vmSize();
    }

    @Override
    public int osDiskSizeInGB() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).osDiskSizeGB();
    }

    @Override
    public OSType osType() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).osType();
    }

    @Override
    public ContainerServiceStorageProfileTypes storageProfile() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).storageProfile();
    }

    @Override
    public String subnetName() {
        if (this.subnetName != null) {
            return this.subnetName;
        }
        return ResourceUtils.nameFromResourceId((String)((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID());
    }

    @Override
    public String networkId() {
        String subnetId = this.inner() != null ? ((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        return subnetId != null ? ResourceUtils.parentResourceIdFromResourceId((String)subnetId) : null;
    }

    public KubernetesClusterAgentPoolImpl withVirtualMachineSize(ContainerServiceVMSizeTypes param0) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withVmSize(param0);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSType(OSType osType) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withOsType(osType);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSDiskSizeInGB(int osDiskSizeInGB) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    @Override
    public KubernetesClusterAgentPool.DefinitionStages.WithAttach withAgentPoolVirtualMachineCount(int count) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withCount(count);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withMaxPodsCount(int podsCount) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withMaxPods(podsCount);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        String vnetSubnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.subnetName = subnetName;
        ((ManagedClusterAgentPoolProfile)this.inner()).withVnetSubnetID(vnetSubnetId);
        return this;
    }

    public KubernetesCluster.Definition attach() {
        ((ManagedClusterInner)((Object)((KubernetesClusterImpl)this.parent()).inner())).agentPoolProfiles().add((ManagedClusterAgentPoolProfile)this.inner());
        return (KubernetesCluster.Definition)this.parent();
    }
}

